<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//ini_set('display_errors', 1);

class EtpCronJobController extends CI_Controller {

    public function __construct()
    {
		parent::__construct();
		$this->load->model('Common_model');
		$this->load->library('email');
		$this->load->model('ChartModel');
		$this->load->model('Etp_model_cronjob');
    }

    public function databaseBackup()
	{
	    $filename='digitalEtp_live_'.date('G_a_m_d_y').'.sql';

	    $result=exec('mysqldump techfasi_eprv2 --password=tagsci123@#$ --user=techfasi_eprv2 --single-transaction >/home/techfasi/DatabaseBackup/Digital-ETP/'.$filename,$output);

	    if(empty($output)){
	        echo $logmessage = "Database Download Success : ".date("Y-m-d H:i:s");
	    }else {
	        echo $logmessage = "Database Download Error : ".date("Y-m-d H:i:s");
	    }
	}

    public function report_parameter_chart()
    {
    	$unit_id = $this->input->get("id");
    	$frequencyshift_value = $this->input->get("frequencyshift_value");
    	$unit_id = $this->Common_model->decrypt($unit_id);
    	$data['unit_id'] = $unit_id;
    	$data['frequencyshift_value'] = $frequencyshift_value;
    	$unit_data = $this->Common_model->getIdWiseData("units","unit_id",$unit_id);

    	if($unit_data !=''){

    		$this->Etp_model_cronjob->UnitShiftConstant($unit_id);

    		$data['unit_data'] = $unit_data;

	    	$data['sublocation_list'] = $this->Etp_model_cronjob->getSublocationList($unit_id);
	    	$data['location_name'] = 'Treated Effluent';
			$this->load->view('daily_log_book/daily_log_book_chart_report',$data);

    	} else {

    		echo "Record not found.";
    	}
    }

	public function sendCronjobDailyShiftReport($unit_id)
	{
		//http://techfilessolutions.in/Digital-ETP/cronjob/etp/daily-shift-report/1
		//http://techfilessolutions.in/Digital-ETP/cronjob/etp/daily-shift-report/1?shift_type=Shift1

		$unit_data = $this->Etp_model_cronjob->getIdWiseData("units","unit_id",$unit_id);

		if($unit_data == ''){
			echo "This Unit id not found";die();
		}

		$unit_name = $unit_data->name;

		$time = date("H:i",strtotime(CURRENT_DATETIME));

		$shift_type = $this->input->get("shift_type");

		$data = array();
		$data['unit_id'] = $unit_id;
		$data['unit_id_encrypted'] = $this->Common_model->encrypt($unit_id);

		$this->Etp_model_cronjob->UnitShiftConstant($unit_id);

		if($shift_type !='' && $shift_type !=null){

			if($shift_type == 'Shift3'){
				$datefilter = date("m/d/Y",strtotime("-1 days"));
			}else{
				$datefilter = date("m/d/Y");
			}

			$array_filter = array("fromDate"=>$datefilter,"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>$shift_type);

			$array_filter['unit_id'] = $unit_id;

			$data['frequencyshift_value'] = $shift_type;
			
			$data['param_audit_data'] = $this->Etp_model_cronjob->getParameterAuditDataModelDailyBook($array_filter);
			$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
			
			//$res = $this->Etp_model_cronjob->sendDailyLogBookCronMail($shift_type,$msg,$unit_id,$unit_name,$datefilter);

		} else { 

			if($unit_id == 4)
			{
				//if($time !='') // send mail manually
				
				if($time >= '09:50' && $time <= '10:05')
				{
					$msg = "";

					$datefilter = date("m/d/Y",strtotime("-1 days"));

					$unit_etpview = $this->Common_model->getIdWiseAllData("etpview","unit_id",$unit_id);

					if($unit_etpview !='' && !empty($unit_etpview))
					{
						foreach ($unit_etpview as $key => $value) {

							$array_filter = array("fromDate"=>$datefilter,"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>'Once in A Day');
							$array_filter['unit_id'] = $unit_id;
							$array_filter['etpview_id'] = $value->Id;
							$data['frequencyshift_value'] = 'Once in A Day / Etp Name : '.$value->name;
							$data['param_audit_data'] = $this->Etp_model_cronjob->getParameterAuditDataModelDailyBook($array_filter);
							
							$msg .= $this->load->view('daily_log_book/daily_log_book_email',$data,true);
						}
					}
					
					$res = $this->Etp_model_cronjob->sendDailyLogBookCronMail("Once in A Day",$msg,$unit_id,$unit_name,$datefilter);
					
					$res = $datefilter." ".date("H:i");
				}
			}
			else if($unit_id == 8 || $unit_id == 13)
			{				
				//if($time !='') // send mail manually
				if($time >= '09:50' && $time <= '10:05')
				{
					$msg = "";
					$data['unit_id'] = $unit_id;
					$datefilter = date("m/d/Y",strtotime("-1 days"));
					$data['date'] = date("Y-m-d",strtotime($datefilter));

					$data['days_array'] = $this->get7DaysDates($datefilter,7);
					$array_filter = array("unit_id"=>$unit_id);
					$param_audit_data = $this->Etp_model_cronjob->getAquaGelAllParameter($array_filter);
					$data['param_audit_data'] = $param_audit_data !='' ? $param_audit_data : array();

					$msg = $this->load->view('daily_log_book/daily_log_book_email_aquagel',$data,true);

					$res = $this->Etp_model_cronjob->sendDailyLogBookCronMail("All Shift",$msg,$unit_id,$unit_name,$datefilter);
					
					$res = $datefilter." ".date("H:i");
				}
			}
			else
			{

				$time_shift_1 = explode('-', $unit_data->Shift1_time);
				$time_shift_2 = explode('-', $unit_data->Shift2_time);
				$time_shift_3 = explode('-', $unit_data->Shift3_time);

				$time_shift_1_1 = $this->Etp_model_cronjob->minusMinitFromTime($time_shift_1[1],10); // 10 then 09:50
				$time_shift_1_2 = $this->Etp_model_cronjob->plusMinitFromTime($time_shift_1[1],5); // 10 then 10:05

				$time_shift_2_1 = $this->Etp_model_cronjob->minusMinitFromTime($time_shift_2[1],10);
				$time_shift_2_2 = $this->Etp_model_cronjob->plusMinitFromTime($time_shift_2[1],5);

				$time_shift_3_1 = $this->Etp_model_cronjob->minusMinitFromTime($time_shift_3[1],10);
				$time_shift_3_2 = $this->Etp_model_cronjob->plusMinitFromTime($time_shift_3[1],5);

				if($time >= $time_shift_1_1 && $time <= $time_shift_1_2){
					//Shift1 end

					$datefilter = date("m/d/Y");

					$array_filter = array("fromDate"=>date("m/d/Y"),"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>'Shift1');

					$array_filter['unit_id'] = $unit_id;

					$data['frequencyshift_value'] = "Shift1";

					$data['param_audit_data'] = $this->Etp_model_cronjob->getParameterAuditDataModelDailyBook($array_filter);
					$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
					$res = $this->Etp_model_cronjob->sendDailyLogBookCronMail("Shift1",$msg,$unit_id,$unit_name,$datefilter);
					
				}else if($time >= $time_shift_2_1 && $time <= $time_shift_2_2 && $unit_id !=2){

					$datefilter = date("m/d/Y");
					//Shift2 end
					$array_filter = array("fromDate"=>date("m/d/Y"),"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>'Shift2');

					$array_filter['unit_id'] = $unit_id;

					$data['frequencyshift_value'] = "Shift2";

					$data['param_audit_data'] = $this->Etp_model_cronjob->getParameterAuditDataModelDailyBook($array_filter);
					$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
					$res = $this->Etp_model_cronjob->sendDailyLogBookCronMail("Shift2",$msg,$unit_id,$unit_name,$datefilter);
					
				}if($time >= $time_shift_3_1 && $time <= $time_shift_3_2  && $unit_id !=2){
					//Shift3 end
					$datefilter = date("m/d/Y",strtotime("-1 days"));
					$array_filter = array("fromDate"=>$datefilter,"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>'Shift3');

					$array_filter['unit_id'] = $unit_id;

					$data['frequencyshift_value'] = "Shift3";

					$data['param_audit_data'] = $this->Etp_model_cronjob->getParameterAuditDataModelDailyBook($array_filter);
					$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
					$res = $this->Etp_model_cronjob->sendDailyLogBookCronMail("Shift3",$msg,$unit_id,$unit_name,$datefilter);
				}
			}
		}

		echo $res;
	}

	function get7DaysDates($date, $days){
	      $m = date("m",strtotime($date)); $de= date("d",strtotime($date)); $y= date("Y",strtotime($date));
	      $dateArray = array();
	      $format = 'Y-m-d';
	      for($i=0; $i<=$days-1; $i++){
	          $dateArray[] = date($format, mktime(0,0,0,$m,($de-$i),$y)); 
	      }
	      //return array_reverse($dateArray);
	      return $dateArray;
	  }

}//end of class
	
?>
 
 