<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//ini_set('display_errors', 1);

class WaterMeterController extends CI_Controller {

    public function __construct()
    {
		parent::__construct();
		$this->load->model('Common_model');
		$this->load->library('email');
		$this->load->model('Etp_model');
		$this->load->model('WaterMeter_model');
		$this->load->model('ChartModel');
    }

    public function WaterMeterListAdd()
    {
    	if ($this->session->userdata('uid'))
        { 
        	$this->load->view('water_meter/water_meter'); 
        }
        else
        {
        	redirect("/");
        }
    }

    public function WaterMeterEdit()
    {
    	if ($this->session->userdata('uid'))
        { 
        	$id = $this->input->get("id");
        	if($id !=''){
        		$data['p1'] = $id;
        		$data['edit_data'] = $this->Etp_model->getIdWiseData("water_meter","Id",$id);
        		$this->load->view('water_meter/edit_water_meter',$data); 	
        	}
        	
        }
        else
        {
        	redirect("/");
        }	
    }

    public function WaterMeterInsert()
    {
    	if ($this->session->userdata('uid'))
        { 
        	$uid=trim($this->input->post('uid'));
			$name=trim($this->input->post('name'));
			$unit_id=trim($this->input->post('unit_id'));	
			$location_name=trim($this->input->post('location_name'));

			$frequency=trim($this->input->post('frequency'));
			$frequency_shift=trim($this->input->post('frequency_shift'));
			$startdate=trim($this->input->post('startdate'));
			$units=trim($this->input->post('units'));

			$id=trim($this->input->post('Id'));

			$enddate="2028-12-31";

			if($uid !='' && $name !='')
			{
				$startdate=date( "Y-m-d", strtotime( "$startdate" ) );

				$data_insert = array(
					'name'=>$name,
					'uid'=>$uid,
					'unit_id'=>$unit_id,
					'location_name'=>$location_name,
					'arrival_in'=>date('Y-m-d H:i:s'),
					'units'=>$units,
					'startdate'=>$startdate,
					'enddate'=>$enddate,
					'frequency'=>$frequency,
					'frequency_shift'=>$frequency_shift,
				);


				if($id !=''){
					$inserted_id = $this->Etp_model->updateData("water_meter","Id",$id,$data_insert);
					$inserted_id = $id;
				}else{
					$inserted_id = $this->Etp_model->insertData("water_meter",$data_insert);
				}
				

				if($id !=''){
					$msg = "Water Meter Updated";
					$this->popupmsg($msg);
				}else{

					if($inserted_id !=''){
						$this->session->set_flashdata('success_message', 'Inserted success');
					}else{
						$this->session->set_flashdata('error_message', 'Inserted error');
					}

					redirect($_SERVER['HTTP_REFERER']);	
				}
			}	
			else
			{
				redirect($_SERVER['HTTP_REFERER']);
			}

        }
        else
        {
        	redirect("/");
        }
    }

    public function deleteWaterMeter($id)
	{
		$this->WaterMeter_model->deleteWaterMeterData($id);
		redirect($_SERVER['HTTP_REFERER']);
	}

	public function WaterMeterAuditView()   ///dashboard for operator
	{
		if ($this->session->userdata('uid'))
        { 
			$user_id=$this->session->userdata('uid'); 

			$data['location_data'] = $this->WaterMeter_model->getLocationDataWithStatus($user_id);
			$selectedlocation_id = $data['location_data'] !='' ? $data['location_data'][0]->Id : 0;
						
			if(!$this->session->userdata('selected_location_id_water')) {
				$this->session->set_userdata("selected_location_id_water",$selectedlocation_id); 
			}else{
				$selectedlocation_id = $this->session->userdata("selected_location_id_water");
			}

			$array_arg = array("user_id"=>$user_id,"location_id"=>$selectedlocation_id);
			$data['water_data'] = $this->WaterMeter_model->getWaterMeterWithLocation($array_arg);
			
			$this->load->view('water_meter/water_meter_audit_view',$data); 
        }
        else
        {
        	redirect("/");
        }
	}

	public function WaterMeter_CurrentValue_insert()/*parameter_currentvalue_check*/
	{
		$id = $this->input->post("id");
		$current_value = $this->input->post("current_value");
		$frequency = $this->input->post("frequency");

		$uid=$this->session->userdata('uid'); 
		$plant_id=$this->session->userdata('plant_id');

		if($id !='' && $current_value !='' && $uid !='' && $plant_id !=''){

			//change selected value of location
			$this->session->set_userdata("selected_location_id_water",$location_id); 

			$array_arg = array("water_m_id"=>$id,"current_value"=>$current_value,"frequency"=>$frequency,"plant_id"=>$plant_id,"uid"=>$uid);

			$insert_value = $this->WaterMeter_model->insertCurrentValueWaterMeterAudit($array_arg);

			if($insert_value)
			{
				$this->session->set_flashdata('success_message', "Audit Inserted Successfully");
			}
			else
			{
				$this->session->set_flashdata('error_message', "Audit Inserted Error");
			}

			redirect($_SERVER['HTTP_REFERER']);

		}else{
			$this->session->set_flashdata('error_message', "Please insert current value");
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	public function getLocationWiseWaterMeter()
	{
		$user_id=$this->session->userdata('uid'); 
		$location_id=$this->input->post('location_id');

		$this->session->set_userdata("selected_location_id_water",$location_id); //for selected display location on refresh

		$array_arg = array("user_id"=>$user_id,"location_id"=>$location_id);
		$data['water_data'] = $this->WaterMeter_model->getWaterMeterWithLocation($array_arg);

		$this->load->view("water_meter/water_meter_audit_view_filter",$data);
	}

	public function report_watermeter_audit()
	{
		$unit_id=$this->session->userdata('unit_id');
		$data['water_audit_data'] = $this->WaterMeter_model->getWaterMeterAuditDataModel();

		$data['water_meter_list'] = $this->WaterMeter_model->getWaterMeterList($unit_id);

		$this->load->view("water_meter/water_meter_report",$data);	
	}
	
	public function updateCurrentValueWaterMeterAdmin()
	{
		$data['Id'] = trim($this->input->get('id'));
		$array_filter = array("updateView"=>$data['Id']);
		$data['audit_data'] = $this->WaterMeter_model->getWaterMeterAuditDataModel($array_filter);
		$this->load->view("water_meter/water_meter_audit_update",$data);
	}

	public function edit_watermeter_current_value_action()
	{
		$current_value_new = $this->input->post("current_value_new");
		$audit_remark = $this->input->post("audit_remark");
		$id = $this->input->post("id");
		$water_m_id = $this->input->post("water_m_id");
		
		$data = array("current_value_new"=>$current_value_new,"audit_remark"=>$audit_remark,"updated_at"=>CURRENT_DATETIME);
			
		$this->Etp_model->updateData("water_meter_audits","Id",$id,$data);

		$msg="Current Value Updated.";
		$this->popupmsg($msg);	

	}

	public function auditReportFilterMeterNo()
	{
		$water_meter_id = trim($this->input->post("water_meter_id"));

		if($water_meter_id !='')
		{
			$water_meter_id = trim($water_meter_id,"'");
			
			$array_filter = array("water_meter_id"=>$water_meter_id);

			$data['water_audit_data'] = $this->WaterMeter_model->getWaterMeterAuditDataModel($array_filter);

			$this->load->view("water_meter/water_meter_report_filter",$data);
		}
		else
		{
			return "";
		}
	}

	public function popupmsg($msg=NULL)
	{
		$p1=$msg;//msg
		$this->Common_model->down_check('PopupMsg',$p1,$p2=NULL,$p3=NULL,$p4=NULL,$p5=NULL,$p6=NULL,$p7=NULL,$p8=NULL,$p9=NULL,$p10=NULL,$p11=NULL,$p12=NULL,$p13=NULL,$p14=NULL,$p15=NULL);
	}

	public function reportWaterAuditBarChart()
	{
		$_POST['todate'] = date('Y-m-d');
		$_POST['fromdate'] = date('Y-m-d',strtotime("-7 days"));

		$data = $this->ChartModel->getWaterMeterAuditReportDate($_POST);

		print_r(json_encode($data,true));
	}

	public function reportWaterConsumptionGraph()
	{
		$_POST['todate'] = date('Y-m-d');
		$_POST['fromdate'] = date('Y-m-d',strtotime("-7 days"));

		$data = $this->ChartModel->GetWaterConsumptionGraphDate($_POST);

		print_r(json_encode($data,true));
	}

}//end of class
	
?>