<?php 

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';

class EtpApiController extends REST_Controller {

	protected $table_users = 'users';

	public function __construct()
	{  
		parent::__construct();
		$this->load->model('EtpApiModel');
        $this->load->model('Common_model');
        $this->load->model('ImageUpload');
        $this->load->model('Etp_model');
        $techfiles = array();
	}

    public function etpViewList_get()
    {
        $user_id = trim($this->input->get("user_id"));

        if(isset($user_id) && $user_id !='')
        {
            $headers = $this->input->request_headers();

            if (array_key_exists('Authorization', $headers) && !empty($headers['Authorization']))
            {
                $decodedToken = $this->Common_model->validateHeaderToken($headers['Authorization'],$user_id);

                if($decodedToken != false) 
                {
                    if(isset($decodedToken) && $decodedToken !='')
                    {
                        $etpviewdata = $this->EtpApiModel->getEtpViewList($decodedToken->unit_id);

                        if($etpviewdata !='')
                        {
                            $status = "success";
                            $message = "Etp Record found.";
                            $techfiles = $etpviewdata;
                        }
                        else
                        {
                            $status = EMPTY_STATUS;
                            $message = "Etp Record not found.";
                            $techfiles = (object)$user_id;
                        }
                    }
                    else
                    {
                        $status = EMPTY_STATUS;
                        $message = "Record not found.";
                        $techfiles = (object)$user_id;
                    }
                }
                else
                {
                    $status = "invalid";
                    $message = SESSION_EXPIRE_MSG;
                    $techfiles = (object)$user_id;
                }
            }
            else
            {
                $status = "header request failed";
                $message = '';
                $techfiles =  (object)$user_id;
            }
        }
        else
        {
            $status = 'incomplete';
            $message = 'Please complete all fields.';
            $techfiles = (object)$user_id;
        }
        
        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);
    }

    public function etpLocationList_get()
    {
        $user_id = trim($this->input->get("user_id"));
        $etpview_id = trim($this->input->get("etpview_id"));
        $current_shift = trim($this->input->get("current_shift"));

        if(isset($user_id) && $user_id !='' && $etpview_id !='' && $current_shift !='')
        {
            $headers = $this->input->request_headers();

            if (array_key_exists('Authorization', $headers) && !empty($headers['Authorization']))
            {
                $decodedToken = $this->Common_model->validateHeaderToken($headers['Authorization'],$user_id);

                if($decodedToken != false) 
                {
                    if(isset($decodedToken) && $decodedToken !='')
                    {
                        $array_arg = array("unit_id"=>$decodedToken->unit_id,"etpview_id"=>$etpview_id,"user_id"=>$user_id,"current_shift"=>$current_shift);
                        $location_data = $this->EtpApiModel->getEtpLocationWithAuditStatus($array_arg);

                        if($location_data !='')
                        {
                            $status = "success";
                            $message = "Etp Location Record.";
                            $techfiles = $location_data;
                        }
                        else
                        {
                            $status = EMPTY_STATUS;
                            $message = "Etp Location Record not found.";
                            $techfiles = (object)$user_id;
                        }
                    }
                    else
                    {
                        $status = EMPTY_STATUS;
                        $message = "Record not found.";
                        $techfiles = (object)$user_id;
                    }
                }
                else
                {
                    $status = "invalid";
                    $message = SESSION_EXPIRE_MSG;
                    $techfiles = (object)$user_id;
                }
            }
            else
            {
                $status = "header request failed";
                $message = '';
                $techfiles =  (object)$user_id;
            }
        }
        else
        {
            $status = 'incomplete';
            $message = 'Please complete all fields.';
            $techfiles = (object)$user_id;
        }
        
        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);
    }

    public function etpParameterList_get()
    {
        $user_id = trim($this->input->get("user_id"));
        $location_id = trim($this->input->get("location_id"));
        $current_shift = trim($this->input->get("current_shift"));

        if(isset($user_id) && $user_id !='' && $location_id !='' && $current_shift !='')
        {
            $headers = $this->input->request_headers();

            if (array_key_exists('Authorization', $headers) && !empty($headers['Authorization']))
            {
                $decodedToken = $this->Common_model->validateHeaderToken($headers['Authorization'],$user_id);

                if($decodedToken != false) 
                {
                    if(isset($decodedToken) && $decodedToken !='')
                    {
                        $array_arg = array("unit_id"=>$decodedToken->unit_id,"location_id"=>$location_id,"user_id"=>$user_id,"current_shift"=>$current_shift);
                        $parameter_data = $this->EtpApiModel->getParameterListFromLocation($array_arg);

                        if($parameter_data !='')
                        {
                            $status = "success";
                            $message = "Parameter Record.";
                            $techfiles = $parameter_data;
                        }
                        else
                        {
                            $status = EMPTY_STATUS;
                            $message = "Parameter Record not found.";
                            $techfiles = (object)$user_id;
                        }
                    }
                    else
                    {
                        $status = EMPTY_STATUS;
                        $message = "Record not found.";
                        $techfiles = (object)$user_id;
                    }
                }
                else
                {
                    $status = "invalid";
                    $message = SESSION_EXPIRE_MSG;
                    $techfiles = (object)$user_id;
                }
            }
            else
            {
                $status = "header request failed";
                $message = '';
                $techfiles =  (object)$user_id;
            }
        }
        else
        {
            $status = 'incomplete';
            $message = 'Please complete all fields.';
            $techfiles = (object)$user_id;
        }
        
        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);
    }

}

?>