<?php

Class ChartModel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getParameterAuditReportDate($data_arg)
    {
    	$fromdate = $data_arg['fromdate'];
    	$todate = $data_arg['todate'];

    	$plant_id=$this->session->userdata('unit_id'); 
        $unit_id=$this->session->userdata('unit_id');

    	$year = date('Y'); 

        //,ur.userid 

        $sql = "select d.date as month, CASE WHEN (current_value_new !='0.00' AND current_value_new !='') THEN ifnull(current_value_new,0) ELSE current_value END as total from 
            (select adddate('1970-01-01',t4.i*10000 + t3.i*1000 + t2.i*100 + t1.i*10 + t0.i) date from
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t0,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t1,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t2,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t3,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t4) d
            left join parameter_audits u on d.date = date(u.created_at)";

        if($data_arg['location_id'] !=''){
            $sql .=" AND u.location_id = '".$data_arg['location_id']."'";
        }

        if($data_arg['parameter_id'] !=''){
            $sql .=" AND parameter_id = '".$data_arg['parameter_id']."'";
        }

        $sql .=" AND unit_id = '".$unit_id."'";

        if($data_arg['frequencyshift_value'] !='' && $data_arg['frequencyshift_value'] !='All'){
            
            if($data_arg['frequencyshift_value'] == 'Shift1'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift2'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift3'){
                $sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
            }
        }
        
        //$sql .=" LEFT JOIN users ur ON u.uid = ur.Id";

        $sql .=" where d.date between '".$fromdate."' and '".$todate."'";

        $sql.=" group by d.date order by d.date";

        $sql_result = $this->db->query($sql);

        $result = $sql_result->result();

        /*foreach ($result as $key => $value) {

            $data = array_map(function ($value) {
                return [
                    $value->month,
                    $value->total
                ];
            }, $result);
        }*/

        return $result;
    }

    public function getEnergyMeterAuditReportDate($data_arg)
    {
        $fromdate = $data_arg['fromdate'];
        $todate = $data_arg['todate'];

        $plant_id=$this->session->userdata('unit_id'); 
        $unit_id=$this->session->userdata('unit_id');

        $year = date('Y'); 

        //,ur.userid 

        $sql = "select d.date as month, CASE WHEN (current_value_new !='0.00' && current_value_new !='') THEN ifnull(current_value_new,0) ELSE current_value END as total from 
            (select adddate('1970-01-01',t4.i*10000 + t3.i*1000 + t2.i*100 + t1.i*10 + t0.i) date from
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t0,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t1,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t2,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t3,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t4) d
            left join energy_meter_audits u on d.date = date(u.created_at)";

        if($data_arg['energy_m_id'] !=''){
            $sql .=" AND energy_m_id = '".$data_arg['energy_m_id']."'";
        }

        $sql .=" AND unit_id = '".$unit_id."'";

        if($data_arg['frequencyshift_value'] !='' && $data_arg['frequencyshift_value'] !='All'){
            
            if($data_arg['frequencyshift_value'] == 'Shift1'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift2'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift3'){
                $sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
            }
        }
        
        //$sql .=" LEFT JOIN users ur ON u.uid = ur.Id";

        $sql .=" where d.date between '".$fromdate."' and '".$todate."'";

        $sql.=" group by d.date order by d.date";

        $sql_result = $this->db->query($sql);

        $result = $sql_result->result();

        return $result;
    }

    public function getWaterMeterAuditReportDate($data_arg)
    {
        $fromdate = $data_arg['fromdate'];
        $todate = $data_arg['todate'];

        $plant_id=$this->session->userdata('unit_id'); 
        $unit_id=$this->session->userdata('unit_id');

        $year = date('Y'); 

        //,ur.userid 

        $sql = "select d.date as month, CASE WHEN (current_value_new !='0.00' && current_value_new !='') THEN ifnull(current_value_new,0) ELSE current_value END as total from 
            (select adddate('1970-01-01',t4.i*10000 + t3.i*1000 + t2.i*100 + t1.i*10 + t0.i) date from
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t0,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t1,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t2,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t3,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t4) d
            left join water_meter_audits u on d.date = date(u.created_at)";

        if($data_arg['water_m_id'] !=''){
            $sql .=" AND water_m_id = '".$data_arg['water_m_id']."'";
        }

        $sql .=" AND unit_id = '".$unit_id."'";

        if($data_arg['frequencyshift_value'] !='' && $data_arg['frequencyshift_value'] !='All'){
            
            if($data_arg['frequencyshift_value'] == 'Shift1'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift2'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift3'){
                $sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
            }
        }
        
        //$sql .=" LEFT JOIN users ur ON u.uid = ur.Id";

        $sql .=" where d.date between '".$fromdate."' and '".$todate."'";

        $sql.=" group by d.date order by d.date";

        $sql_result = $this->db->query($sql);

        $result = $sql_result->result();

        return $result;
    }

    public function GetEnergyConsumptionGraphDate($data_arg)
    {
        $fromdate = $data_arg['fromdate'];
        $todate = $data_arg['todate'];

        $plant_id=$this->session->userdata('unit_id'); 
        $unit_id=$this->session->userdata('unit_id');

        $year = date('Y'); 

        //,ur.userid 

        $sql = "select d.date as month, CASE WHEN (current_value_new !='0.00' && current_value_new !='') THEN ifnull(current_value_new,0) ELSE current_value END as total,Id,energy_m_id from 
            (select adddate('1970-01-01',t4.i*10000 + t3.i*1000 + t2.i*100 + t1.i*10 + t0.i) date from
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t0,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t1,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t2,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t3,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t4) d
            left join energy_meter_audits u on d.date = date(u.created_at)";

        if($data_arg['energy_m_id'] !=''){
            $sql .=" AND energy_m_id = '".$data_arg['energy_m_id']."'";
        }

        $sql .=" AND unit_id = '".$unit_id."'";

        if($data_arg['frequencyshift_value'] !='' && $data_arg['frequencyshift_value'] !='All'){
            
            if($data_arg['frequencyshift_value'] == 'Shift1'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift2'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift3'){
                $sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
            }
        }
        
        //$sql .=" LEFT JOIN users ur ON u.uid = ur.Id";

        $sql .=" where d.date between '".$fromdate."' and '".$todate."'";

        $sql.=" group by d.date order by d.date";

        $sql_result = $this->db->query($sql);

        $result = $sql_result->result();

        $result = $sql_result->result();

        if(!empty($result))
        {
            $data = array();

            foreach ($result as $key => $value) {
                if(isset($value->Id) && $value->Id !=null){

                    $consumption_prev = $this->EnergyMeter_model->getEnergyConsumptionValue($value->Id,$value->energy_m_id);
                    if($consumption_prev !='false'){
                        $consumption = $consumption_prev - $value->total;
                        $consumption = abs($consumption);
                    }else{
                        $consumption = 0;
                    }
                }else{
                    $consumption = 0;
                }

                $value->total = $consumption;

                $data[] = $value;
            }
            return $data;
        } else {
            return array();
        }


    }

    public function GetWaterConsumptionGraphDate($data_arg)
    {
        $fromdate = $data_arg['fromdate'];
        $todate = $data_arg['todate'];

        $plant_id=$this->session->userdata('unit_id'); 
        $unit_id=$this->session->userdata('unit_id');

        $year = date('Y'); 

        //,ur.userid 

        $sql = "select d.date as month, CASE WHEN (current_value_new !='0.00' && current_value_new !='') THEN ifnull(current_value_new,0) ELSE current_value END as total,Id,water_m_id from 
            (select adddate('1970-01-01',t4.i*10000 + t3.i*1000 + t2.i*100 + t1.i*10 + t0.i) date from
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t0,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t1,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t2,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t3,
             (select 0 i union select 1 union select 2 union select 3 union select 4 union select 5 union select 6 union select 7 union select 8 union select 9) t4) d
            left join water_meter_audits u on d.date = date(u.created_at)";

        if($data_arg['water_m_id'] !=''){
            $sql .=" AND water_m_id = '".$data_arg['water_m_id']."'";
        }

        $sql .=" AND unit_id = '".$unit_id."'";

        if($data_arg['frequencyshift_value'] !='' && $data_arg['frequencyshift_value'] !='All'){
            
            if($data_arg['frequencyshift_value'] == 'Shift1'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift2'){
                $sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
            }elseif($data_arg['frequencyshift_value'] == 'Shift3'){
                $sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
            }
        }
        
        //$sql .=" LEFT JOIN users ur ON u.uid = ur.Id";

        $sql .=" where d.date between '".$fromdate."' and '".$todate."'";

        $sql.=" group by d.date order by d.date";

        $sql_result = $this->db->query($sql);

        $result = $sql_result->result();

        if(!empty($result))
        {
            $data = array();

            foreach ($result as $key => $value) {
                if(isset($value->Id) && $value->Id !=null){

                    $consumption_prev = $this->WaterMeter_model->getWaterConsumptionValue($value->Id,$value->water_m_id);
                    if($consumption_prev !='false'){
                        $consumption = $consumption_prev - $value->total;
                        $consumption = abs($consumption);
                    }else{
                        $consumption = 0;
                    }
                }else{
                    $consumption = 0;
                }

                $value->total = $consumption;

                $data[] = $value;
            }
            return $data;
        } else {
            return array();
        }

        
    }

    public function getLocationWiseParameterChartCronMail($array_filter)
    {        
        $audit_filter = '';
        $parameter_filter = '';

        if(isset($array_filter['frequencyshift_value']) && $array_filter['frequencyshift_value'] !='All')
        {
            if($array_filter['frequencyshift_value'] == 'Shift1'){
                $audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
            }elseif($array_filter['frequencyshift_value'] == 'Shift2'){
                $audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
            }elseif($array_filter['frequencyshift_value'] == 'Shift3'){
                $audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
            }else{}

            /*current date check */
            $current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
            $current_time = date("H:i",strtotime(CURRENT_DATETIME));
            if($current_time >= '00:00' && $current_time <= Shift_3_end){
                $current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
            }
            $audit_filter .=" AND (DATE(audit_date_time) = '".$current_date."')";
            /* end */

            if($array_filter['frequencyshift_value'] == 'Once in A Day'){

                $parameter_filter .=" AND (pr.frequency_shift = '".$array_filter['frequencyshift_value']."')";

            }else{

                $parameter_filter .=" AND (pr.frequency_shift = '".$array_filter['frequencyshift_value']."' OR pr.frequency_shift = 'All Shift')";
            }
        }  

        $sql = "SELECT pr.name,CASE WHEN (current_value_new !='0.00' AND current_value_new !='') THEN ifnull(current_value_new,0) ELSE current_value END as total from parameters pr LEFT JOIN parameter_audits pa ON (pr.Id = pa.parameter_id ".$audit_filter.") WHERE pr.location_id = ".$array_filter['location_id']."  AND pr.status !='1'";

        $sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";

        $sql .=$parameter_filter;

        $sql .=" group by pr.Id ORDER BY pa.Id DESC";
        
        //$res = "SELECT pr.name,CASE WHEN (current_value_new !='0.00' AND current_value_new !='') THEN ifnull(current_value_new,0) ELSE current_value END as total  FROM `parameter_audits` pa INNER JOIN parameters pr ON pa.parameter_id = pr.Id where pa.location_id = ".$array_filter['location_id']."  AND pr.status !='1' GROUP BY pa.parameter_id";


        $res = $this->db->query($sql);

        if($res->num_rows() > 0){
            return $res->result();
        }else{
            return array();
        }
    }
}

?>