<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Etp_model_cronjob extends CI_Model {

	public function __construct()
	{
		parent::__construct();
	}

	public function UnitShiftConstant($unit_id=null)
	{
		if($unit_id ==null){
			$unit_id=$this->session->userdata('unit_id');
		}
				
		if($unit_id !=null){
			$this->db->where("unit_id",$unit_id);
		}
        $res = $this->db->get("units")->row();

        $Shift1_time = $res->Shift1_time !='' ? explode('-',$res->Shift1_time) : '';
        $Shift2_time = $res->Shift2_time !='' ? explode('-',$res->Shift2_time) : '';
        $Shift3_time = $res->Shift3_time !='' ? explode('-',$res->Shift3_time) : '';
        
        define("Shift_1_start", $Shift1_time[0] !='' ? $Shift1_time[0] : '07:30');

        define("Shift_1_end", $Shift1_time !='' ? $Shift1_time[1] : '15:30');
        define("Shift_2_start", $Shift2_time !='' ? $Shift2_time[0] : '15:30');
        define("Shift_2_end", $Shift2_time !='' ? $Shift2_time[1] : '23:30');
        define("Shift_3_start", $Shift3_time !='' ? $Shift3_time[0] : '23:30');
        define("Shift_3_end", $Shift3_time !='' ? $Shift3_time[1] : '07:30');

        return $res;
	}

	public function getParameterAuditDataModelDailyBook($array_filter=null)
	{
		//echo Shift_1_start;die();

		$role=$this->session->userdata('role'); 
  		$uid=$this->session->userdata('uid'); 

		$audit_filter = '';
		$parameter_filter = '';

		if($array_filter !=null)
		{
			if(isset($array_filter['etpview_id']) && $array_filter['etpview_id'] !='' && $array_filter['unit_id'] ==4)
			{
				$parameter_filter .=" AND subl.etpview_id = '".$array_filter['etpview_id']."'";
			}

			if(isset($array_filter['fromDate']) && $array_filter['fromDate'] !='')
			{
				$fromDate = date("Y-m-d",strtotime($array_filter['fromDate']));

				//$audit_filter .=" AND DATE(pa.audit_date_time) = '".$fromDate."'";
				$audit_filter .=" AND (CASE WHEN pr.frequency = 'Monthy' THEN  DATE(pa.audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 MONTH AND '".$fromDate."' WHEN pr.frequency ='Weekly' THEN DATE(pa.audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 WEEK AND '".$fromDate."' WHEN pr.frequency = 'Daily' THEN DATE(pa.audit_date_time) = '".$fromDate."' ELSE '' END)";
			}

			if(isset($array_filter['frequency_value']) && $array_filter['frequency_value'] !='All')
			{
				$parameter_filter .=" AND pr.frequency = '".$array_filter['frequency_value']."'";
			}

			if(isset($array_filter['frequencyshift_value']) && $array_filter['frequencyshift_value'] !='All')
			{
				if($array_filter['frequencyshift_value'] == 'Shift1'){
					$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
					$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
					$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
				}else{}

				/*current date check */
	            $current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
	            $current_time = date("H:i",strtotime(CURRENT_DATETIME));
	            if($current_time >= '00:00' && $current_time <= Shift_3_end){
	                $current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
	            }

	            if($array_filter['unit_id'] ==4){
	            	if(isset($array_filter['fromDate']) && $array_filter['fromDate'] !='')
					{
						$fromDate = date("Y-m-d",strtotime($array_filter['fromDate']));
	            		$audit_filter .=" AND (DATE(audit_date_time) = '".$fromDate."')";
	            	}	
	            }else{
	            	$audit_filter .=" AND (DATE(audit_date_time) = '".$current_date."')";
	            }
	            
	            /* end */

				if($array_filter['frequencyshift_value'] == 'Once in A Day'){

					$parameter_filter .=" AND (pr.frequency_shift = '".$array_filter['frequencyshift_value']."')";

				}else{

					//$parameter_filter .=" AND (pr.frequency_shift = '".$array_filter['frequencyshift_value']."' OR pr.frequency_shift = 'All Shift')";
				}
			}
		}

		$sql = "select pr.*,pa.current_value,pa.current_value_new,pa.audit_date_time,pa.range_status,pa.Id as audit_id,ur.userid,subl.name as sub_name,subl.etpview_id as etpview_id from parameters pr LEFT JOIN parameter_audits pa ON (pr.Id = pa.parameter_id ".$audit_filter.") LEFT JOIN users ur ON ur.Id = pa.uid INNER JOIN sublocations subl ON pr.location_id = subl.Id where 1=1 ".$parameter_filter."";

		$sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";
		

		if(isset($array_filter['unit_id']) && $array_filter['unit_id'] !=''){
			$sql .=" AND (pr.unit_id = '".$array_filter['unit_id']."')";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";
		$sql .=" AND subl.deleted_at = '0000-00-00 00:00:00'";

		$sql .=" AND pr.status !='1'";

		$sql .=" AND subl.status !='1'";
		
        //$sql .=" group by pr.Id ORDER BY pa.Id DESC"; //Working
        //$sql .=" group by pr.Id ORDER BY subl.name,pr.name DESC";
        $sql .=" group by pr.Id ORDER BY subl.arrival_in ASC";
        
		$sql_res = $this->db->query($sql);

		//echo $this->db->last_query();die();

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

/* New changes for water and energy meter report */

	public function getEnergyMeterAuditDataModelDailyBook($array_filter=null)
	{
		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
        $current_time = date("H:i",strtotime(CURRENT_DATETIME));
        if($current_time >= '00:00' && $current_time <= Shift_3_end){
            $current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
        }

		$audit_filter = " AND DATE(audit_date_time) = '".$current_date."'";

		if($array_filter['frequencyshift_value'] == 'Shift1'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
			$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
		}else{}
		
		$sql = "select pr.*,pa.current_value,pa.current_value_new,pa.audit_date_time,pa.Id as audit_id,ur.userid from energy_meter pr LEFT JOIN energy_meter_audits pa ON (pr.Id = pa.energy_m_id ".$audit_filter.") LEFT JOIN users ur ON ur.Id = pa.uid where 1=1";

		$sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";

		if(isset($array_filter['unit_id']) && $array_filter['unit_id'] !=''){
			$sql .=" AND (pr.unit_id = '".$array_filter['unit_id']."')";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		$sql .=" AND pr.status !='1'";

        $sql .=" group by pr.Id ORDER BY pr.arrival_in ASC";
        
		$sql_res = $this->db->query($sql);

		//echo $this->db->last_query();die();

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getWaterMeterAuditDataModelDailyBook($array_filter=null)
	{
		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
        $current_time = date("H:i",strtotime(CURRENT_DATETIME));
        if($current_time >= '00:00' && $current_time <= Shift_3_end){
            $current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
        }
        
		$audit_filter = " AND DATE(audit_date_time) = '".$current_date."'";

		if($array_filter['frequencyshift_value'] == 'Shift1'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
			$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
		}else{}
		
		$sql = "select pr.*,pa.current_value,pa.current_value_new,pa.audit_date_time,pa.Id as audit_id,ur.userid from water_meter pr LEFT JOIN water_meter_audits pa ON (pr.Id = pa.water_m_id ".$audit_filter.") LEFT JOIN users ur ON ur.Id = pa.uid where 1=1";

		$sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";

		if(isset($array_filter['unit_id']) && $array_filter['unit_id'] !=''){
			$sql .=" AND (pr.unit_id = '".$array_filter['unit_id']."')";
		}
		
		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		$sql .=" AND pr.status !='1'";

        $sql .=" group by pr.Id ORDER BY pr.arrival_in ASC";
        
		$sql_res = $this->db->query($sql);

		//echo $this->db->last_query();die();

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getEnergyMeterParameterList($array_filter)
	{
		$sql = "select pr.* from energy_meter pr where 1=1";

		$sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";

		if(isset($array_filter['unit_id']) && $array_filter['unit_id'] !=''){
			$sql .=" AND (pr.unit_id = '".$array_filter['unit_id']."')";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		$sql .=" AND pr.status !='1'";

        $sql .=" group by pr.Id ORDER BY pr.arrival_in ASC";
        
		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getWaterMeterParameterList($array_filter)
	{
		$sql = "select pr.* from water_meter pr where 1=1";

		$sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";

		if(isset($array_filter['unit_id']) && $array_filter['unit_id'] !=''){
			$sql .=" AND (pr.unit_id = '".$array_filter['unit_id']."')";
		}
		
		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		$sql .=" AND pr.status !='1'";

        $sql .=" group by pr.Id ORDER BY pr.arrival_in ASC";
        
		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getIdWiseAuditDataForEnergyMeter($array_filter)
	{
		$audit_filter = "1=1";

		$audit_filter .= " AND DATE(audit_date_time) = '".$array_filter['fromDate']."'";

		if($array_filter['frequencyshift_value'] == 'Shift1'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
			$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
		}else{}

        $this->db->where($audit_filter);
		$this->db->where("unit_id",$array_filter['unit_id']);
		$this->db->where("energy_m_id",$array_filter['parameter_id']);
        $res = $this->db->get("energy_meter_audits");

        //echo $this->db->last_query()."<br>";//die();

        if($res->num_rows() > 0){
        	return $res->row();
        }else{
        	return "";
        }
	}
	
	public function getIdWiseAuditDataForWaterMeter($array_filter)
	{
		$audit_filter = "1=1";

		$audit_filter .= " AND DATE(audit_date_time) = '".$array_filter['fromDate']."'";

		if($array_filter['frequencyshift_value'] == 'Shift1'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
			$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
		}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
			$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
		}else{}

        $this->db->where($audit_filter);
		$this->db->where("unit_id",$array_filter['unit_id']);
		$this->db->where("water_m_id",$array_filter['parameter_id']);
        $res = $this->db->get("water_meter_audits");

        //echo $this->db->last_query()."<br>";//die();

        if($res->num_rows() > 0){
        	return $res->row();
        }else{
        	return "";
        }
	}

	public function getEnergyConsumptionValue($current_id,$water_id)
	{
		$sql = $this->db->query("select current_value from energy_meter_audits where Id = (select Id from energy_meter_audits where Id < '".$current_id."' AND energy_m_id = '".$water_id."' ORDER BY Id DESC LIMIT 0,1 )");

		if($sql->num_rows() > 0){
			$result_value = $sql->row();
			return $result_value->current_value;
		}else{
			return 'false';
		}
	}
	public function getWaterConsumptionValue($current_id,$water_id)
	{
		$sql = $this->db->query("select current_value from water_meter_audits where Id = (select Id from water_meter_audits where Id < '".$current_id."' AND water_m_id = '".$water_id."' ORDER BY Id DESC LIMIT 0,1 )");

		if($sql->num_rows() > 0){
			$result_value = $sql->row();
			return $result_value->current_value;
		}else{
			return 'false';
		}
	}
	
/* end report */

	function minusMinitFromTime($time,$minit){
		$time = strtotime($time);
		$time = $time - ($minit * 60);
		return $time_final = date("H:i", $time);
	}

	function plusMinitFromTime($time,$minit){
		$time = strtotime($time);
		$time = $time + ($minit * 60);
		return $time_final = date("H:i", $time);
	}


	function getUnitViewerEmail($unit_id){
		$query = $this->db->query("SELECT ifnull(GROUP_CONCAT(emailid),'') as admin_email FROM `users` where unit_id = ".$unit_id."  AND role = 4 AND status = 0");
		if($query->num_rows() > 0){
			return $email = $query->row()->admin_email;
		}else{
			return false;
		}
	}

	public function bkp_170523sendDailyLogBookCronMail($shift_type,$message_table=null,$unit_id=null,$unit_name=null,$date=null)
	{
		//'megha.sharma@unilever.com','nishant.srivastav@designx.in','dinesh.patil@unilever.com'

		//$to = array('anukritika.jha@unilever.com','megha.sharma@unilever.com','nishant.srivastav@designx.in','dinesh.patil@unilever.com','deep.sheth@designx.in');

		$email_unit_viewer = $this->getUnitViewerEmail($unit_id);

		$to = $email_unit_viewer !='' ? $email_unit_viewer : 'deep.sheth@designx.in';
		
		if($unit_id ==4){
			//$to .= ",CS.Velu@unilever.com,T.Manivasagam@unilever.com,Nafisa.begam@unilever.com,SM.Muthusamy@unilever.com,Hirenkumar.solanki@unilever.com,MANU.SUNNY@unilever.com,SP.Manickam@unilever.com,Amalanathan.Mariasusai@unilever.com,Vishakha.Jayakumar@unilever.com";//Commented on 8-8-22
			//Sivasubramaniam.Purushothaman@unilever.com
		}

		
		if($unit_id ==5 || $unit_id ==13){
			$to .= ',srijan.srivastava@designx.in';
		}
		
		$from= "donotreply@techfilessolutions.in";

		if($unit_id ==4){
			$subject = 'Digital ETP report - '.$unit_name;
		}else{
			$subject = 'Digital ETP report - '.$unit_name." - ".$shift_type;
		}

		$message = "<p>Hello Admin</p>";
		$date = $date !=null ? $date : '';
		$message .= "<p>Here is daily log book report for Date : ".$date.".</p>";

		//$message .="<p>Click below link to view audit report.</p><br>";
		
		//$message .="<a href='".site_url()."etp/daily-log-book'>".site_url()."etp/daily-log-book</a>";

		if($message_table !=null){
			$message .= $message_table;
		}
		
		//echo $to = "kiran.suthar@designx.in,srijan.srivastava@designx.in";//die();

		//$to = "kiran.suthar@designx.in";

		$res = $this->Common_model->sendemail($from,$to,$message,$subject);

		if($res){

			//if($unit_id == 13){
				$logdata = json_encode(array("emailids"=>$to,"unit_id"=>$unit_id));
				$insertLog = array("arrival_in"=>date('Y-m-d H:i:s'),"logdata"=>$logdata);
				$this->Common_model->insertData("cronjob_log",$insertLog);
			//}
			
			return true;
		}else{
			return false;
		}
	}

	//@kiran@17-5-23 ETP mail send function for cronjob
	public function sendDailyLogBookCronMail($shift_type,$message_table=null,$unit_id=null,$unit_name=null,$date=null)
	{
		$email_unit_viewer = $this->getUnitViewerEmail($unit_id);
		if(!$email_unit_viewer){
			return false;
		}
		$to = $email_unit_viewer;
		if($unit_id ==5 || $unit_id ==13){
			$to .= ',srijan.srivastava@designx.in';
		}

		$subject = 'Digital ETP report - '.$unit_name." - ".$shift_type;
		if($unit_id ==4){
			$subject = 'Digital ETP report - '.$unit_name;
		}

		$message = "<p>Hello Admin</p>";
		$date = $date !=null ? $date : date('Y-m-d');
		$message .= "<p>Here is daily log book report for Date ".$date.".</p>";
		if($message_table !=null){
			$message .= $message_table;
		}

		$from= "donotreply@techfilessolutions.in";
		$res = $this->Common_model->sendemail($from,$to,$message,$subject);
		if(!$res){
			return false;
		}

		$logdata = json_encode(array("emailids"=>$to,"unit_id"=>$unit_id));
		$insertLog = array("arrival_in"=>date('Y-m-d H:i:s'),"logdata"=>$logdata);
		$this->Common_model->insertData("cronjob_log",$insertLog);
	}

	public function getIdWiseData($table,$fieldname,$id,$unit_id=null)
	{
		if($unit_id !=null){
			$this->db->where("unit_id",$unit_id);
		}
        $this->db->where($fieldname, $id);
        $res = $this->db->get($table)->row();
        return $res;
	}

	public function getSublocationList($unit_id)
	{
		$etpview_id_report=$this->session->userdata('etpview_id_report');

		if($etpview_id_report !=null && $etpview_id_report !=''){
			$this->db->where("etpview_id",$etpview_id_report);
		}
		$this->db->where("unit_id",$unit_id);
		$this->db->where("status !=",1);
		$this->db->where("deleted_at","0000-00-00 00:00:00");
        $res = $this->db->get("sublocations");
        if($res->row() > 0){
        	return $res->result();
        }else{
        	return "";
        }
	}

	public function getAquaGelAllParameter($array_filter)
	{
		$this->db->select("pa.*,subl.name as sub_name");
		$this->db->from("parameters pa");
		$this->db->join("sublocations subl","pa.location_id = subl.Id","LEFT");
		$this->db->where("pa.unit_id",$array_filter['unit_id']);
		$this->db->where("pa.status !=",1);
		$this->db->where("pa.deleted_at","0000-00-00 00:00:00");
		$this->db->where("subl.status !=",1);
		$this->db->where("subl.deleted_at","0000-00-00 00:00:00");
		$this->db->group_by("pa.Id");
		$this->db->order_by("subl.arrival_in","ASC");
        $res = $this->db->get("parameters");
        if($res->row() > 0){
        	return $res->result();
        }else{
        	return "";
        }
	}

	public function getAquaGelParameterWiseAuditData($array_filter)
	{
		$audit_filter = "1=1";

		if(isset($array_filter['fromDate'])){
			$fromDate = $array_filter['fromDate'];
			if($array_filter['frequency'] == 'Monthy'){
				$audit_filter .= " AND DATE(audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 MONTH AND '".$fromDate."'";
			}else if($array_filter['frequency'] =='Weekly'){
				$audit_filter .= " AND DATE(audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 WEEK AND '".$fromDate."'";
			}else if($array_filter['frequency'] == 'Daily'){
				$audit_filter .= " AND DATE(audit_date_time) = '".$fromDate."'";
			}
		}

		if(isset($array_filter['frequencyshift_value']) && $array_filter['frequencyshift_value'] !='All')
		{
			if($array_filter['frequencyshift_value'] == 'Shift1'){
				$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
			}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
				$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
			}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
				$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
			}	
		}

        $this->db->where($audit_filter);
		$this->db->where("unit_id",$array_filter['unit_id']);
		$this->db->where("parameter_id",$array_filter['parameter_id']);
        $res = $this->db->get("parameter_audits");

        //echo $this->db->last_query()."<br>";//die();

        if($res->num_rows() > 0){
        	return $res->row();
        }else{
        	return "";
        }
	}
}

?>