<?php 
defined( 'BASEPATH') OR exit( 'No direct script access allowed'); 
$this->load->view('includes/header_start'); 
date_default_timezone_set('Asia/Kolkata'); 
?>
<!--Morris Chart CSS -->
<link rel="stylesheet" href="<?=site_url();?>assets/plugins/morris/morris.css">
<!-- DataTables -->
<link href="<?=site_url();?>/assets/plugins/datatables/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
<link href="<?=site_url();?>/assets/plugins/datatables/buttons.bootstrap4.min.css" rel="stylesheet" type="text/css" />
<!-- Responsive datatable examples -->
<link href="<?=site_url();?>/assets/plugins/datatables/responsive.bootstrap4.min.css" rel="stylesheet" type="text/css" />
<!-- Multi Item Selection examples -->
<link href="<?=site_url();?>/assets/plugins/datatables/select.bootstrap4.min.css" rel="stylesheet" type="text/css" />

<?php $this->load->view('includes/header_end'); 
$role=$this->session->userdata('role'); 
$unit_id=$this->session->userdata('unit_id');
$uid=$this->session->userdata('uid'); 
$emp_id=$this->session->userdata('empid'); 
$plant_id=$this->session->userdata('plant_id'); 
?>

<style type="text/css">
  .btnLocation{
    margin-bottom: 11px;
    margin-right: 13px;
    color: black;
    font-size: 18px;
    border: 2px solid white;
  }
  .LocationArea{
    background: white;
    padding: 15px;
    border-radius: 7px;
  }
  .LocationArea > p{
    text-align: left;
    font-size: 24px;
    font-weight: bold;
  }
  .parameterArea{
    background: white;
    padding: 15px;
    border-radius: 7px;
  }
  button.btn.btn-large.btnLocation:focus{
    border:2px solid !important
    ;
  }
  .status_pending{
    background: #FFC800 !important;
  }
  .status_open{
    background: #00A6F3 !important;
  }
  .status_done{
    background: #00D997 !important;
  }
  .active_location{
    border: 2px solid black;
  }
  /* hide number arrow */
  input[type='number'] {
    -moz-appearance:textfield;
  }
  input::-webkit-outer-spin-button,
  input::-webkit-inner-spin-button {
    -webkit-appearance: none;
  }
  /* end*/
  .currentShiftLabel{
    text-align: right;
    font-size: 14px;
    text-transform: uppercase;
    color: #3FB898;
    font-weight: bold;
  }
  .submitBtnClass{
    float: right;
    margin-left: 9px;
    margin-bottom: 10px;
    padding: 8px 17px 6px;
    font-size: 15px;
  }
</style>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="content-page">
  <!-- Start content -->
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-xl-12">
          <div class="page-title-box">
            <h4 class="page-title float-left">Audit Manual</h4>
            <div class="clearfix"></div>
          </div>
        </div>
      </div>
      <div class="row">
        <!-- message area -->

        <div class="col-md-12">
          <div class="LocationArea">

              <div class="message_display">
                <?php if($this->session->flashdata('success_message') !='') { ?>
                <div class="alert alert-success">
                  <strong></strong> <?php echo $this->session->flashdata('success_message'); ?>
                </div>
                <?php } ?>

                <?php if($this->session->flashdata('error_message') !='') { ?>
                <div class="alert alert-danger">
                  <strong></strong> <?php echo $this->session->flashdata('error_message'); ?>
                </div>
                <?php } ?>
              </div>

              <form id="manualetp" method="post" action="<?=site_url();?>etp/manual/insert">

                <?php
                    $csrf = array('name' => $this->security->get_csrf_token_name(),'hash' => $this->security->get_csrf_hash());
                ?>
                <input type="hidden" name="<?=$csrf['name'];?>" value="<?=$csrf['hash'];?>" />
                
                  <div class="form-group row">

                    <div class="col-md-4">
                       <label for="units" >Audit Meter</label> 
                        <select name="audit_meter" id="audit_meter" required="required" class="form-control">
                          <option value="etp">ETP</option>
                          <option value="energy_meter">Energy Meter</option>
                          <option value="water_meter">Water Meter</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                       <label for="units" >Units</label> 
                        <select name="unit_id" id="unit_id" required="required" class="form-control">
                          <option value="">--* Select Unit--</option>
                            <?php foreach ($unit_list as $key => $value) { ?>
                              <option value="<?=$value->unit_id;?>"><?=$value->name;?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                       <label for="units" >Plant</label> 
                        <select name="plant_id" id="plant_id" required="required" class="form-control">
                          <option value="">--* Select Plant--</option>
                        </select>
                    </div>
                  </div>

                  <div class="form-group row">
                    <div class="col-md-4">
                       <label for="units" >Users</label> 
                        <select name="user_id" id="user_id" required="required" class="form-control">
                          <option value="">--* Select User--</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                       <label for="units" >Location</label> 
                        <select name="location_id" id="location_id" required="required" class="form-control">
                          <option value="">--* Select Location--</option>
                            <?php foreach ($location_data as $key => $value) { ?>
                              <option value="<?=$value->Id;?>"><?=$value->name;?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                       <label for="units" >Parameters</label> 
                        <select name="parameter_id" id="parameter_id" required="required" class="form-control">
                          <option value="">--* Select Location--</option>
                        </select>
                    </div>
                  </div>
                  <div class="form-group row">
                    <div class="col-md-12">
                       <label for="units" >Shift</label> 
                        <select name="shift" id="shift" required="required" class="form-control">
                          <option value="">--* Select Shift--</option>
                          <option value="Shift1">Shift1</option>
                          <option value="Shift2">Shift2</option>
                          <option value="Shift3">Shift3</option>
                          <option value="Once in A Day">Once in A Day</option>
                        </select>
                    </div>
                  </div>

                  <div class="form-group row">
                    <div class="col-md-12">
                        <label for="units" >Date</label> 
                        <input class="form-control form-control-inline date-picker" size="16" type="text" name="date" id="AuditDateFilter" placeholder="Date" required="required" value="" />
                    </div>
                  </div>

                  <div class="form-group row">
                    <div class="col-md-12">

                      <label for="units" style="display: block;">Current Value</label>

                      <input type="number" style="width:70%;float: left;" min="0" class="form-control" name="current_value" class="current_value_parameter" value="" id="inputCurrentValueId" maxlength="5" step=".01" />

                      <div style="float: left;margin-left: 6px;"><span>N/A</span><input type="checkbox" class="form-control current_value_checkbox" rel="" name="current_value" value="N/A"></div>

                      <!-- <div style="float: left;margin-left: 6px;"><span>Yes</span><input type="radio" class="form-control current_value_radio" name="current_value" value="Yes"></div>

                      <div style="float: left;margin-left: 10px;"><span>No</span><input type="radio" class="form-control current_value_radio" name="current_value" value="No"></div> -->
                    </div>
                  </div>

                  <div class="form-group row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary waves-effect waves-light">
                        Submit
                      </button>
                      <button type="reset" class="btn btn-secondary waves-effect m-l-5">Cancel
                      </button>
                    </div>
                  </div>

              </form>
          </div>
          <br>
          
        </div>
      </div>
    </div>
  </div>
  <!-- container -->
</div>
<!-- content -->
<?php $this->load->view('includes/footer_start'); ?>


<!-- date picker -->
<script src="<?=site_url();?>/assets/plugins/moment/moment.js"></script>
<script src="<?=site_url();?>/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script src="<?=site_url();?>/assets/pages/jquery.form-pickers.init.js"></script>
<!--   /date picker -->

<script type="text/javascript">

  $('#audit_meter').on('change', function() {
    $("#unit_id").val('');
  });

  $('#unit_id').on('change', function() {
    var unit_id = $(this).val();
    if(unit_id && unit_id !=''){
        getPlantList(unit_id);
        getLocationList(unit_id);
    }
  });

  $('#plant_id').on('change', function() {
    var plant_id = $(this).val();
    if(plant_id && plant_id !=''){
        getUserList(plant_id);
    }
  });

  

  $('#location_id').on('change', function() {
    var location_id = $(this).val();
    if(location_id && location_id !=''){
        getParameterList(location_id);
    }
  });

  function getParameterList(location_id)
  {
    var unit_id = $("#unit_id option:selected").val();
    var audit_meter = $("#audit_meter option:selected").val();

    $.ajax({
        url : site_url+"EtpManualController/parameterLocationWise",
        type : 'GET',
        data : {location_id:location_id,unit_id:unit_id,audit_meter:audit_meter},
        success : function(data) { 

          $('#parameter_id').find('option').remove(); 

          $('#parameter_id').append($("<option></option>").attr("value",'').text("---Select Parameter---")); 

          if(data && data !='' && data !='false'){
            var data = JSON.parse(data);
            $.each(data, function(key, value) {   
             $('#parameter_id').append($("<option></option>")
                            .attr("value",value.Id)
                            .text(value.name)); 
            });
          }
        },
        error : function(request,error)
        {
            alert("Request: "+JSON.stringify(request));
        }
    });
  }

  function getPlantList(unit_id)
  {
    $.ajax({
        url : site_url+"EtpManualController/plantListUnitWise",
        type : 'GET',
        data : {unit_id:unit_id},
        success : function(data) { 

          $('#plant_id').find('option').remove(); 

          $('#plant_id').append($("<option></option>").attr("value",'').text("---Select Plant---")); 

          if(data && data !='' && data !='false'){
            var data = JSON.parse(data);
            $.each(data, function(key, value) {   
             $('#plant_id').append($("<option></option>")
                            .attr("value",value.plant_id)
                            .text(value.name)); 
            });
          }
        },
        error : function(request,error)
        {
            alert("Request: "+JSON.stringify(request));
        }
    });
  }

  function getLocationList(unit_id)
  {
    var audit_meter = $("#audit_meter option:selected").val();

    $.ajax({
        url : site_url+"EtpManualController/locationListUnitWise",
        type : 'GET',
        data : {unit_id:unit_id,audit_meter:audit_meter},
        success : function(data) { 

          $('#location_id').find('option').remove(); 

          $('#location_id').append($("<option></option>").attr("value",'').text("---Select Location---")); 

          if(data && data !='' && data !='false'){
            var data = JSON.parse(data);
            $.each(data, function(key, value) {   
             $('#location_id').append($("<option></option>")
                            .attr("value",value.Id)
                            .text(value.name)); 
            });
          }
        },
        error : function(request,error)
        {
            alert("Request: "+JSON.stringify(request));
        }
    });
  }

  function getUserList(plant_id)
  {
    var unit_id = $("#unit_id option:selected").val();

    $.ajax({
        url : site_url+"EtpManualController/userListUnitPlantWise",
        type : 'GET',
        data : {unit_id:unit_id,plant_id:plant_id},
        success : function(data) { 

          $('#user_id').find('option').remove(); 

          $('#user_id').append($("<option></option>").attr("value",'').text("---Select User---")); 

          if(data && data !='' && data !='false'){
            var data = JSON.parse(data);
            $.each(data, function(key, value) {   
             $('#user_id').append($("<option></option>")
                            .attr("value",value.Id)
                            .text(value.userid)); 
            });
          }
        },
        error : function(request,error)
        {
            alert("Request: "+JSON.stringify(request));
        }
    });
  }

</script>

<script type="text/javascript">
  $('.date-picker').datepicker();
</script>
<script type="text/javascript">
  $(document).ajaxStop(function () {
    $("#loading_ajax").hide();
  });

  $(document).ajaxStart(function () {
      $("#loading_ajax").show();
  });
</script>
<?php $this->load->view('includes/footer_end'); ?>
