<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Etp_model extends CI_Model {

	public function __construct()
	{
		parent::__construct();
	}

	public function getLocationDataWithStatus($user_id=null)
	{
		$plant_id=$this->session->userdata('plant_id');

		$sql = "select * from sublocations where 1=1";
		//$sql .=" AND plant_id = '".$plant_id."'";

		$sql .=" ORDER BY name";

		$sql_res = $this->db->query($sql);
		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getParameterWithLocation($array_arg=null)
	{
		$unit_id=$this->session->userdata('unit_id');

		$sql = "select pr.*,lo.name as location_name,lo.id as location_id from parameters pr INNER JOIN sublocations lo ON lo.id = pr.location_id where 1=1";

		if(isset($array_arg['location_id']) && $array_arg['location_id'] !='' && $array_arg['location_id'] !='All'){
			$sql .=" AND pr.location_id = '".$array_arg['location_id']."'";
		}

		$sql .=" AND pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."'";

		//$sql .=" AND pr.unit_id = '".$unit_id."'";

		$sql .=" ORDER BY location_name";

		$sql_res = $this->db->query($sql);
		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function checkCurrentValueRange($param_id,$current_value)
	{
		$sql = "SELECT * FROM `parameters` where Id = ".$param_id." AND ".$current_value." BETWEEN minrange AND maxrange";

		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return "false";
		}
	}

	public function insertCurrentValueParamAudit($arg_data)
	{
		$audit_date_time = $this->checkCurrentTimeShift3();

		$arg_data['audit_date_time'] = $audit_date_time;
		$arg_data['created_at'] = $audit_date_time;
		$arg_data['updated_at'] = $audit_date_time;

		$this->db->insert('parameter_audits',$arg_data);
		return $this->db->insert_id();
	}

	function checkCurrentTimeShift3()
	{
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));
		//
		if(($current_time >= Shift_3_start && $current_time <= '23:59') || ($current_time >= '00:00' && $current_time <= '07:00')){
			return $current_date = date ('Y-m-d H:i:s',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
		}else{
			return CURRENT_DATETIME;
		}
	}

	public function getParameterAuditDataModel($array_filter=null)
	{
		$role=$this->session->userdata('role'); 
  		$uid=$this->session->userdata('uid'); 
		$unit_id=$this->session->userdata('unit_id');

		$sql = "select pa.*,pr.name,ur.userid,subl.name as sub_name from parameter_audits pa INNER JOIN parameters pr ON pr.Id = pa.parameter_id INNER JOIN users ur ON ur.Id = pa.uid INNER JOIN sublocations subl ON pa.location_id = subl.Id where 1=1";
		
		//$sql .=" AND pr.unit_id = '".$unit_id."'";

		if($array_filter !=null)
		{
			if(isset($array_filter['filter_range']) && $array_filter['filter_range'] !='' && $array_filter['filter_range'] !='completed')
			{
				$sql .=" AND pa.range_status = 'out_range'";
			}

			if(isset($array_filter['updateView']))
			{
				$sql .=" AND pa.id = ".$array_filter["updateView"]."";
			}

			if(isset($array_filter['fromDate']) && $array_filter['fromDate'] !='')
			{
				$fromDate = date("Y-m-d",strtotime($array_filter['fromDate']));

				$sql .=" AND DATE(pa.audit_date_time) = '".$fromDate."'";

				//$toDate = date("Y-m-d",strtotime($array_filter['toDate']));

				//$sql.=" AND DATE(pa.audit_date_time) BETWEEN '".$fromDate."' AND '".$toDate."'";
			}

			if(isset($array_filter['frequency_value']) && $array_filter['frequency_value'] !='All')
			{
				$sql .=" AND pr.frequency = 'Every Shift'";

				if($array_filter['frequency_value'] == 'Shift1'){
					$sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
				}elseif($array_filter['frequency_value'] == 'Shift2'){
					$sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
				}elseif($array_filter['frequency_value'] == 'Shift3'){
					$sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
				}
			}
		}

		//echo $sql;

		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getIdWiseData($table,$fieldname,$id)
	{
        $this->db->where($fieldname, $id);
        $res = $this->db->get($table)->row();
        return $res;
	}

	public function getTableData($table)
	{
        $res = $this->db->get($table);
        if($res->row() > 0){
        	return $res->result();
        }else{
        	return "";
        }
	}

	public function updateData($table, $id_field_name, $id, $data)
    {
        $this->db->where($id_field_name, $id);
        $this->db->update($table, $data);
        return true;
    }

	public function getIdWiseAllData($table,$fieldname,$id)
	{
		$this->db->where($fieldname, $id);
        $res = $this->db->get($table);
        if($res->row() > 0){
        	return $res->result();
        }else{
        	return "";
        }
	}

	public function checkLocationAuditStatus($location_id,$parameter_id=null)
	{
		$uid=$this->session->userdata('uid'); 

		$this->db->where("startdate <= ", date('Y-m-d',strtotime(CURRENT_DATETIME)));
		$this->db->where("location_id", $location_id);

		if($parameter_id !=null)
		{
			$this->db->where("Id",$parameter_id);
		}

        $res = $this->db->get("parameters");

        //echo $this->db->last_query();die();
        
        if($res->num_rows() > 0){

        	$result = $res->result();

        	$data = array();

        	foreach ($result as $key => $value) {
        		
        		if($value->frequency == 'Daily')
        		{
        			$data[] = $this->CheckFrequencyEntryDaily($value->Id);
        		}
        		else if($value->frequency == 'Monthly')
        		{
        			$param_data = $this->getLastMonthlyAuditUser($value->Id,$uid);

        			if($param_data !=''){
        				$startdate = date('Y-m-d',strtotime($param_data->audit_date_time));
        			}else{
	        			$startdate = $value->startdate;
        			}
        			
        			$data[] = $this->CheckFrequencyEntryMonthy($value->Id,$startdate);

        		}else if($value->frequency == 'Every Shift'){

					$data[] = $this->CheckFrequencyEntryEveryShift($value->Id);

        			//$data[] = "pending";
        		}
        		
        	}

        	if(in_array("pending",$data))
        	{
        		return "status_pending";
        	}
        	else
        	{
        		return "status_done";
        	}

        }else{
        	return "status_done";
        }
	}

	function CheckFrequencyEntryDaily($parameter_id)
	{
		$uid=$this->session->userdata('uid'); 

		$sql = $this->db->query("select * from parameter_audits where parameter_id = '".$parameter_id."' AND date(audit_date_time) = '".date("Y-m-d",strtotime(CURRENT_DATETIME))."'");

		//echo $this->db->last_query();

		if($sql->num_rows() > 0)
		{
			return "done";
		}
		else
		{
			return "pending";
		}
	}

	function CheckFrequencyEntryMonthy($parameter_id,$startdate)
	{
		$uid=$this->session->userdata('uid'); 
		$enddate = date('Y-m-d', strtotime('+1 month', strtotime($startdate)));

		$sql = $this->db->query("select * from parameter_audits where parameter_id = '".$parameter_id."' AND date(audit_date_time) BETWEEN '".$startdate."' AND '".$enddate."'");

		//echo $this->db->last_query();

		if($sql->num_rows() > 0)
		{
			return "done";
		}
		else
		{
			return "pending";
		}
	}

	function getLastMonthlyAuditUser($parameter_id,$uid)
	{
		$sql = $this->db->query("select * from parameter_audits where parameter_id = '".$parameter_id."'");

		if($sql->num_rows() > 0)
		{
			$res = $sql->result()[0];
			return $res;
		}
		else
		{
			return "";
		}
	}

	function getLastSubmittedValueAudit($table,$fieldname,$id)
	{
		$this->db->where($fieldname, $id);
		$this->db->order_by("Id","DESC");
        $res = $this->db->get($table)->row();
        return $res;
	}

	function CheckFrequencyEntryEveryShift($param_id)
	{
		/*Shift 1 = 7AM - 3PM
		Shift 2 = 3PM - 11PM
		Shift 3 = 11PM - 7AM*/

		$array_shift = array(Shift_1_start."-".Shift_1_end,Shift_2_start."-".Shift_2_end,Shift_3_start."-".Shift_3_end);
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));
		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));

		//$current_time = '15:00';

		if(($current_time >= Shift_3_start && $current_time <= '23:59') || $current_time >= '00:00' && $current_time <= '07:00'){

			if($current_time >= '23:00' && $current_time <= '23:59'){
				$array_shift[2] = '23:00-23:59';
			}else{
				$array_shift[2] = "00:00-07:00";
				$current_date = date ('Y-m-d',strtotime('+1 day', strtotime(CURRENT_DATETIME)));
			}

			$time = explode('-', $array_shift[2]);

			$sql = $this->db->query("SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."' AND date(created_at) = '".$current_date."'");

			//echo $this->db->last_query();

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_2_start && $current_time < Shift_2_end){
			
			$time = explode('-', $array_shift[1]);

			$sql = $this->db->query("SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."' AND date(created_at) = '".$current_date."'");

			//echo $this->db->last_query();

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_1_start && $current_time < Shift_1_end){
			
			$time = explode('-', $array_shift[0]);

			$sql = $this->db->query("SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."' AND date(created_at) = '".$current_date."'");

			//echo $this->db->last_query();

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else{
			$data = '';
		}		

		/*foreach ($array_shift as $key => $value) {

			$current_time = date("H:i",strtotime(CURRENT_DATETIME));
			$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));

			if($value =='23:00-07:00'){
				if($current_time >= '23:00' && $current_time <= '23:59'){
					$value = '23:00-23:59';
				}else{
					$value = "00:00-07:00";
					$current_date = date ('Y-m-d',strtotime('+1 day', strtotime(CURRENT_DATETIME)));
				}
			}
				
			$time = explode('-', $value);

			$sql = $this->db->query("SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."' AND date(created_at) = '".$current_date."'");

			//echo $this->db->last_query();

			if($sql->num_rows() > 0){
				$data[] = 'done';
			}else{
				$data[] = 'pending';
			}
		}

		if(in_array("pending",$data))
    	{
    		return "pending";
    	}
    	else
    	{
    		return "done";
    	}*/

    	return $data;

	}

	public function sendOutRangeEmailAdmin($array_arg){
				
		//$to = array('sutharkiran743@gmail.com','deep.sheth@designx.in');
		$to = array('development@designx.in','nishant.srivastav@designx.in');

		//$from= "evelopment@designx.in";
		$from= "donotreply@techfilessolutions.in";
		$subject = 'Parameter Audit Current Value Out Range';

		$userdata = $this->Etp_model->getIdWiseData("users","Id",$array_arg['uid']);
		$username = ($userdata !='') ? $userdata->userid : '';

		$parameterdata = $this->Etp_model->getIdWiseData("parameters","Id",$array_arg['parameter_id']);
		$paramname = ($parameterdata !='') ? $parameterdata->name : '';

		$message = "<p>Hello Admin</p>";
		$message .= "<p>Here is out range Audit Submitted</p>";

		$message .="<p>User Name = ".$username."</p>";
		$message .="<p>Parameter Name = ".$paramname."</p>";
		$message .= "<p>Current Value = ".$array_arg['current_value']."</p>";
		$message .="<p>Min Range = ".$array_arg['minrange']."</p>";
		$message .="<p>Max Range = ".$array_arg['maxrange']."</p>";

		$message .="<p>You can check whole report of audit using below link.</p>";
		$message .="<a href='".site_url()."etp/report/report_parameter_audit'>".site_url()."Dashboard/report_parameter_audit</a>";

		$res = $this->Common_model->sendemail($from,$to,$message,$subject);

		if($res)
            echo"Congragulation Email Send Successfully.";
        else
          echo"email_sent","You have encountered an error";
	}
	//end of class...		
}

?>