<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//ini_set('display_errors', 1);

class EtpController extends CI_Controller {

    public function __construct()
    {
		parent::__construct();
		$this->load->model('Common_model');
		$this->load->library('email');
		$this->load->model('Etp_model');
		$this->load->model('ChartModel');
    }

	public function dashboard_operator($msg=NULL)   ///dashboard for operator
	{
		if ($this->session->userdata('uid'))
		{
			if($this->session->userdata('etpview_id')){

				$user_id=$this->session->userdata('uid'); 

				$unit_id=$this->session->userdata('unit_id');

				$etpview_id = $this->session->userdata('etpview_id');

				$data['location_data'] = $this->Etp_model->getLocationDataWithStatus($user_id,$etpview_id);

				$selected_location_id = $data['location_data'] !='' ? $data['location_data'][0]->Id : 0;

				if(!$this->session->userdata('selected_location_id')) {
					$this->session->set_userdata("selected_location_id",$selected_location_id); 
				}else{
					$selected_location_id = $this->session->userdata("selected_location_id");
				}

				$array_arg = array("user_id"=>$user_id,"location_id"=>$selected_location_id,"etpview_id"=>$etpview_id);
				$data['param_data'] = $this->Etp_model->getParameterWithLocation($array_arg);

				$this->load->view('etp/Dashboard_operator',$data); 

			} else {

				redirect("etpview/select_etpview");
			}

		}
		else
		{
			redirect("/");
		}
	}

	public function parameter_currentvalue_check()
	{
		$id = $this->input->post("id");
		$current_value = $this->input->post("current_value");
		$minrange = $this->input->post("minrange");
		$maxrange = $this->input->post("maxrange");
		$frequency = $this->input->post("frequency");
		$location_id = $this->input->post("location_id");

		$uid=$this->session->userdata('uid'); 
		$plant_id=$this->session->userdata('plant_id');

		if($id !='' && $current_value !='' && $uid !='' && $plant_id !=''){

			//change selected value of location
			$this->session->set_userdata("selected_location_id",$location_id); 

			$array_arg = array("parameter_id"=>$id,"minrange"=>$minrange,"maxrange"=>$maxrange,"current_value"=>$current_value,"frequency"=>$frequency,"plant_id"=>$plant_id,"uid"=>$uid,"location_id"=>$location_id);

			if(is_numeric($current_value)){
				$check_value = $this->Etp_model->checkCurrentValueRange($id,$current_value);
				if($check_value !='false'){
					$array_arg['range_status'] = 'in_range';
				}else{
					$array_arg['range_status'] = 'out_range';
				}
			} else {
				$array_arg['range_status'] = '';
			}

			$insert_value = $this->Etp_model->insertCurrentValueParamAudit($array_arg);

			if($insert_value)
			{
				$this->session->set_flashdata('success_message', "Audit Inserted Successfully");
			}
			else
			{
				$this->session->set_flashdata('error_message', "Audit Inserted Error");
			}

			redirect($_SERVER['HTTP_REFERER']);

		}else{
			$this->session->set_flashdata('error_message', "Please insert current value");
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	public function parameter_currentvalue_check_allsubmit()
	{
		$current_value = $this->input->post("current_value"); // array with key as Parameter Id and Value as current value
		$uid=$this->session->userdata('uid'); 
		$plant_id=$this->session->userdata('plant_id');
		$unit_id=$this->session->userdata('unit_id');
		
		$current_value = array_filter($current_value);
		
		if($current_value !='' && !empty($current_value)){

			if($current_value !='' && !empty($current_value)){

				$id_arr = array();

				foreach ($current_value as $key => $value) {

					$param_data = $this->Common_model->getIdWiseData("parameters","Id",$key);

					$array_arg = array("parameter_id"=>$param_data->Id,"minrange"=>$param_data->minrange,"maxrange"=>$param_data->maxrange,"current_value"=>$value,"frequency"=>$param_data->frequency,"plant_id"=>$plant_id,"uid"=>$uid,"location_id"=>$param_data->location_id);

					$this->session->set_userdata("selected_location_id",$param_data->location_id);

					if(is_numeric($value)){

						$check_value = $this->Etp_model->checkCurrentValueRange($param_data->Id,$value);

						if($check_value !='false'){
							$array_arg['range_status'] = 'in_range';
						}else{
							$array_arg['range_status'] = 'out_range';
						}
						
					} else {
						$array_arg['range_status'] = '';
					}

					$insert_value = $this->Etp_model->insertCurrentValueParamAudit($array_arg);
					$id_arr[]=$insert_value;
				}

				if(!empty($id_arr)){
					if($unit_id == 6 || $unit_id == 8 || $unit_id == 26){
						$arg_pass = array("unit_id"=>$unit_id,"audit_type"=>"etp","id"=>$id_arr);
						$this->Etp_model->sendOutRangeEmailToViewer($arg_pass);
					}
				}
			}

			if($insert_value){
				$this->session->set_flashdata('success_message', "Audit Inserted Successfully");
			} else {
				$this->session->set_flashdata('error_message', "Audit Inserted Error");
			}

			redirect($_SERVER['HTTP_REFERER']);

		}else{
			
			$this->session->set_flashdata('error_message', "Please insert current value");
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	public function getLocationWiseParameter()
	{
		$user_id=$this->session->userdata('uid'); 
		$location_id=$this->input->post('location_id');

		$this->session->set_userdata("selected_location_id",$location_id); //for selected display location on refresh

		$array_arg = array("user_id"=>$user_id,"location_id"=>$location_id);
		$data['param_data'] = $this->Etp_model->getParameterWithLocation($array_arg);

		$this->load->view("etp/Dashboard_operator_filter",$data);
	}

	public function report_parameter_audit($etpview_id)
	{
		$unit_id=$this->session->userdata('unit_id');

		$this->session->set_userdata("etpview_id_report",$etpview_id);
		
		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
		$days_ago = date('Y-m-d', strtotime('-7 days', strtotime(CURRENT_DATETIME)));
		$array_filter = array("fromDate"=>$days_ago,"toDate"=>$current_date);
		$data['param_audit_data'] = $this->Etp_model->getParameterAuditDataModel($array_filter);
		
		$data['locations'] = $this->Etp_model->getSublocationList("sublocations");
		$data['parameters'] = $this->Etp_model->getIdWiseAllData("parameters","location_id",4,$unit_id);

		$this->load->view("etp/Report1",$data);	
	}

	public function getParameterFromLocation()
	{
		$unit_id=$this->session->userdata('unit_id');
		$location_id=$this->input->post('location_id');
		$parameters = $this->Etp_model->getIdWiseAllData("parameters","location_id",$location_id,$unit_id);
		
		$output = '<select name="parameters" class="form-control" id="parameter_id" style="width: 30%;float: left;margin-right:10px">';

	    if($parameters !='' && count($parameters) > 0){

	        foreach ($parameters as $key => $value) {
	      		$output .= '<option value="'.$value->Id.'">'.$value->name.'</option>';
	    	}
	    }

	    $output .="</select>";

	    echo $output;
	}
	
	public function reportAuditBarChart()
	{
		$location_id=$this->input->post('location_id');
		$parameter_id=$this->input->post('parameter_id');	

		$_POST['todate'] = date('Y-m-d');
		$_POST['fromdate'] = date('Y-m-d',strtotime("-7 days"));

		$data = $this->ChartModel->getParameterAuditReportDate($_POST);

		print_r(json_encode($data,true));
	}

	public function reportAuditFinalTankBarChart()
	{
		$location_id=$this->input->post('location_id');
		$parameter_id=$this->input->post('parameter_id');	

		$_POST['todate'] = date('Y-m-d');
		$_POST['fromdate'] = date('Y-m-d',strtotime("-7 days"));

		$data = $this->ChartModel->getParameterAuditReportDate($_POST);

		print_r(json_encode($data,true));
	}

	public function updateCurrentValueAdmin()
	{
		$data['Id'] = trim($this->input->get('id'));
		$array_filter = array("updateView"=>$data['Id']);
		$data['audit_data'] = $this->Etp_model->getParameterAuditDataModel($array_filter);
		$this->load->view("etp/parameter_audit_update",$data);
	}

	public function edit_currentvalue_action()
	{
		$current_value_new = $this->input->post("current_value_new");
		$audit_remark = $this->input->post("audit_remark");
		$id = $this->input->post("id");
		$parameter_id = $this->input->post("parameter_id");
		

		$data = array("current_value_new"=>$current_value_new,"audit_remark"=>$audit_remark,"updated_at"=>CURRENT_DATETIME);
		
		if(is_numeric($current_value_new)){
			$check_value = $this->Etp_model->checkCurrentValueRange($parameter_id,$current_value_new);	
			if($check_value !='false'){
				$data['range_status'] = 'in_range';
			}else{
				$data['range_status'] = 'out_range';
			}
		}else{
			$data['range_status'] = '';
		}
				
		$this->Etp_model->updateData("parameter_audits","Id",$id,$data);

		$msg="Current Value Updated.";
		$this->popupmsg($msg);	

	}

	public function auditEtpReportFilter()
	{
		$filter_range = $this->input->post("filter_range");
		$fromDate = $this->input->post("fromDate");
		$toDate = $this->input->post("toDate");

		if($fromDate == '' && $toDate ==''){
			$fromDate = date('Y-m-d', strtotime('-7 days', strtotime(CURRENT_DATETIME)));
			$toDate = date("Y-m-d",strtotime(CURRENT_DATETIME));
		}

		$array_filter = array("filter_range"=>$filter_range,"fromDate"=>$fromDate,"toDate"=>$toDate);

		$data['param_audit_data'] = $this->Etp_model->getParameterAuditDataModel($array_filter);

		$this->load->view("etp/Report1_filter",$data);
	}

	public function popupmsg($msg=NULL)
	{
		$p1=$msg;//msg
		$this->Common_model->down_check('PopupMsg',$p1,$p2=NULL,$p3=NULL,$p4=NULL,$p5=NULL,$p6=NULL,$p7=NULL,$p8=NULL,$p9=NULL,$p10=NULL,$p11=NULL,$p12=NULL,$p13=NULL,$p14=NULL,$p15=NULL);
	}
	
	public function DailyLogBook()
	{
		$data['param_audit_data'] = array();//$this->Etp_model->getParameterAuditDataModelDailyBook();		
		$this->load->view("daily_log_book/daily_log_book",$data);
	}

	public function getDailyBookAuditDateWiseFilter()
	{
		$etpview_id = isset($_POST['etpview_id']) ? $_POST['etpview_id'] : '';

		$array_filter = array("fromDate"=>$_POST['fromDate'],"toDate"=>$_POST['toDate'],"frequency_value"=>$_POST['frequency_value'],"frequencyshift_value"=>$_POST['frequencyshift_value'],"etpview_id"=>$etpview_id);

		$data['param_audit_data'] = $this->Etp_model->getParameterAuditDataModelDailyBook($array_filter);		
		$this->load->view("daily_log_book/daily_log_book_filter",$data);
	}

	public function sendCronjobDailyShiftReport($unit_id)
	{
		//http://techfilessolutions.in/Digital-ETP/cronjob/etp/daily-shift-report/1
		//http://techfilessolutions.in/Digital-ETP/cronjob/etp/daily-shift-report/1?shift_type=Shift1

		$unit_data = $this->Etp_model->getIdWiseData("units","unit_id",$unit_id);

		if($unit_data == ''){
			echo "This Unit id not found";die();
		}

		$unit_name = $unit_data->name;

		$time = date("H:i",strtotime(CURRENT_DATETIME));

		$shift_type = $this->input->get("shift_type");

		if($shift_type !='' && $shift_type !=null){

			if($shift_type == 'Shift3'){
				$datefilter = date("m/d/Y",strtotime("-1 days"));
			}else{
				$datefilter = date("m/d/Y");
			}

			$array_filter = array("fromDate"=>$datefilter,"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>$shift_type);

			$array_filter['unit_id'] = $unit_id;

			$data['param_audit_data'] = $this->Etp_model->getParameterAuditDataModelDailyBook($array_filter);
			$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
			$res = $this->Etp_model->sendDailyLogBookCronMail($shift_type,$msg,$unit_id,$unit_name);

		} else { 

			$time_shift_1 = explode('-', $unit_data->Shift1_time);
			$time_shift_2 = explode('-', $unit_data->Shift2_time);
			$time_shift_3 = explode('-', $unit_data->Shift3_time);

			$time_shift_1_1 = $this->Etp_model->minusMinitFromTime($time_shift_1[1],10);
			$time_shift_1_2 = $this->Etp_model->plusMinitFromTime($time_shift_1[1],5);

			$time_shift_2_1 = $this->Etp_model->minusMinitFromTime($time_shift_2[1],10);
			$time_shift_2_2 = $this->Etp_model->plusMinitFromTime($time_shift_2[1],5);

			$time_shift_3_1 = $this->Etp_model->minusMinitFromTime($time_shift_3[1],10);
			$time_shift_3_2 = $this->Etp_model->plusMinitFromTime($time_shift_3[1],5);
			
			if($time >= $time_shift_1_1 && $time <= $time_shift_1_2){
				//Shift1 end
				$array_filter = array("fromDate"=>date("m/d/Y"),"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>'Shift1');

				$array_filter['unit_id'] = $unit_id;

				$data['param_audit_data'] = $this->Etp_model->getParameterAuditDataModelDailyBook($array_filter);
				$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
				$res = $this->Etp_model->sendDailyLogBookCronMail("Shift1",$msg,$unit_id,$unit_name);

			}else if($time >= $time_shift_2_1 && $time <= $time_shift_2_2){
				//Shift2 end
				$array_filter = array("fromDate"=>date("m/d/Y"),"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>'Shift2');

				$array_filter['unit_id'] = $unit_id;

				$data['param_audit_data'] = $this->Etp_model->getParameterAuditDataModelDailyBook($array_filter);
				$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
				$res = $this->Etp_model->sendDailyLogBookCronMail("Shift2",$msg,$unit_id,$unit_name);
				
			}if($time >= $time_shift_3_1 && $time <= $time_shift_3_2){
				//Shift3 end
				$datefilter = date("m/d/Y",strtotime("-1 days"));
				$array_filter = array("fromDate"=>$datefilter,"toDate"=>'',"frequency_value"=>'All',"frequencyshift_value"=>'Shift3');

				$array_filter['unit_id'] = $unit_id;

				$data['param_audit_data'] = $this->Etp_model->getParameterAuditDataModelDailyBook($array_filter);
				$msg = $this->load->view('daily_log_book/daily_log_book_email',$data,true);
				$res = $this->Etp_model->sendDailyLogBookCronMail("Shift3",$msg,$unit_id,$unit_name);
			}
			
		}

		echo $res;
	}

	public function emailSendTest()
	{
		$to = "kiran.suthar@designx.in";
		$message = "Testing techfiles";
		$subject = "Testing email from techfiles.ai";
		$res = $this->Common_model->sendemail(null,$to,$message,$subject);
		print_r($res);die();
	}

}//end of class
	
?>