<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//ini_set('display_errors', 1);

class EtpManualController extends CI_Controller {

    public function __construct()
    {
		parent::__construct();
		$this->load->model('Common_model');
		$this->load->model('Etp_model');
		$this->load->model('EtpManual_model');
    }

	public function EtpManual()
	{
		if ($this->session->userdata('uid'))
		{
			$user_id=$this->session->userdata('uid'); 
			$this->load->model("EtpView_model");
			$data['unit_list'] = $this->EtpView_model->getUnitListDropdown();

			$this->load->view('etpmanual/etpmanual',$data); 
		}
		else
		{
			redirect("/");
		}
	}

	public function plantListUnitWise()
	{
		$user_id=$this->session->userdata('uid'); 
		$unit_id = $this->input->get("unit_id");
		$plant_data = $this->EtpManual_model->getPlantUnitWise($unit_id);
		print_r(json_encode($plant_data));
	}

	public function userListUnitPlantWise()
	{
		$user_id=$this->session->userdata('uid'); 
		$unit_id = $this->input->get("unit_id");
		$plant_id = $this->input->get("plant_id");
		$user_data = $this->EtpManual_model->getUserListPlantUnitWise($unit_id,$plant_id);
		print_r(json_encode($user_data));
	}

	public function locationListUnitWise()
	{
		$user_id=$this->session->userdata('uid'); 
		$unit_id = $this->input->get("unit_id");
		$audit_meter = $this->input->get("audit_meter");

		if($audit_meter == 'etp'){
			$location_data = $this->EtpManual_model->getLocationPlantWise($unit_id);
		}else if($audit_meter == 'water_meter'){
			$location_data = $this->EtpManual_model->getLocationPlantWiseEnergy_Water($unit_id,"water_meter");
		}else if($audit_meter == 'energy_meter'){
			$location_data = $this->EtpManual_model->getLocationPlantWiseEnergy_Water($unit_id,"energy_meter");
		}
		
		print_r(json_encode($location_data));
	}

	public function parameterLocationWise()
	{
		$location_id = $this->input->get("location_id");
		$unit_id = $this->input->get("unit_id");
		$audit_meter = $this->input->get("audit_meter");

		$array_arg = array("location_id"=>$location_id,"unit_id"=>$unit_id);

		if($audit_meter == 'etp'){
			$param_data = $this->EtpManual_model->getParameterLocationWise($array_arg);
		}else if($audit_meter == 'water_meter'){
			$array_arg['table'] = "water_meter";
			$param_data = $this->EtpManual_model->getParameterLocationWiseEnergy_Water($array_arg);

		}else if($audit_meter == 'energy_meter'){
			$array_arg['table'] = "energy_meter";
			$param_data = $this->EtpManual_model->getParameterLocationWiseEnergy_Water($array_arg);
		}

		print_r(json_encode($param_data));

	}

	public function EtpManualInsert()
	{
		$parameter_id = $this->input->post("parameter_id");
		$current_value = $this->input->post("current_value");
		$shift = $this->input->post("shift");
		$location_id = $this->input->post("location_id");
		$date = $this->input->post("date");
		$audit_meter = $this->input->post("audit_meter");

		$uid=$this->session->userdata('uid'); 

		$user_id = $this->input->post("user_id");

		$plant_id = $this->input->post("plant_id");
		$unit_id = $this->input->post("unit_id");

		if($parameter_id !='' && $current_value !='' && $uid !='' && $plant_id !='' && $audit_meter !='' && $user_id !='')
		{
			$date = date("Y-m-d",strtotime($date));
			
			$array_arg = array();

			if($audit_meter == "etp"){

				$parameter_data = $this->Common_model->getIdWiseData("parameters","Id",$parameter_id);

				$array_arg = array("parameter_id"=>$parameter_id,"minrange"=>$parameter_data->minrange,"maxrange"=>$parameter_data->maxrange,"current_value"=>$current_value,"frequency"=>$parameter_data->frequency,"plant_id"=>$plant_id,"uid"=>$user_id,"location_id"=>$location_id);

				if(is_numeric($current_value)){
					$check_value = $this->Etp_model->checkCurrentValueRange($parameter_id,$current_value);
					if($check_value !='false'){
						$array_arg['range_status'] = 'in_range';
					}else{
						$array_arg['range_status'] = 'out_range';
					}
				} else {
					$array_arg['range_status'] = '';
				}

			}else if($audit_meter == "water_meter"){

				$parameter_data = $this->Common_model->getIdWiseData("water_meter","Id",$parameter_id);

				$array_arg = array("water_m_id"=>$parameter_id,"current_value"=>$current_value,"frequency"=>$parameter_data->frequency,"plant_id"=>$plant_id,"uid"=>$user_id);

			}else if($audit_meter == "energy_meter"){

				$parameter_data = $this->Common_model->getIdWiseData("energy_meter","Id",$parameter_id);

				$array_arg = array("energy_m_id"=>$parameter_id,"current_value"=>$current_value,"frequency"=>$parameter_data->frequency,"plant_id"=>$plant_id,"uid"=>$user_id);
			}

			$pass_arg = array("date"=>$date,"shift"=>$shift,"unit_id"=>$unit_id);
			$current_time = $this->getShiftWiseDateWiseManual($pass_arg);

			$array_arg['unit_id'] = $unit_id;
			$array_arg['audit_date_time'] = $current_time;
			$array_arg['created_at'] = $current_time;
			$array_arg['updated_at'] = $current_time;
				
			if($audit_meter == "etp"){
				$this->db->insert('parameter_audits',$array_arg);
			}else if($audit_meter == "water_meter"){
				$this->db->insert('water_meter_audits',$array_arg);
			}else if($audit_meter == "energy_meter"){
				$this->db->insert('energy_meter_audits',$array_arg);
			}

			$insert_value = $this->db->insert_id();

			if($insert_value)
			{
				$this->session->set_flashdata('success_message', "Audit Inserted Successfully");
			}
			else
			{
				$this->session->set_flashdata('error_message', "Audit Inserted Error");
			}

			redirect($_SERVER['HTTP_REFERER']);

		}else{
			$this->session->set_flashdata('error_message', "Please insert current value");
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	function getShiftWiseDateWiseManual($array_arg)
	{
		$date = $array_arg['date'];
		$shift = $array_arg['shift'];
		$unit_id = $array_arg['unit_id'];

		$unit_data = $this->Common_model->getIdWiseData("units","unit_id",$unit_id);

		$current_time = date("Y-m-d H:i:s");

		$time_shift_1 = explode('-', $unit_data->Shift1_time);
		$time_shift_2 = explode('-', $unit_data->Shift2_time);
		$time_shift_3 = explode('-', $unit_data->Shift3_time);

		$time_shift1 = $this->plusMinitFromTime($time_shift_1[0],15);
		$time_shift2 = $this->plusMinitFromTime($time_shift_2[0],15);
		$time_shift3 = $this->plusMinitFromTime($time_shift_3[0],15);

		if($shift == "Shift1"){
			$current_time = $date." ".$time_shift1;
		}else if($shift == "Shift2"){
			$current_time = $date." ".$time_shift2;
		}else if($shift == "Shift3"){
			$current_time = $date." ".$time_shift3;
		}else if($shift == "Once In A Day"){
			$current_time = $date." ".date("H:i:s");
		}else{
			$current_time = $date." ".date("H:i:s");
		}

		return $current_time;
	}

	function minusMinitFromTime($time,$minit){
		$time = strtotime($time);
		$time = $time - ($minit * 60);
		return $time_final = date("H:i:s", $time);
	}

	function plusMinitFromTime($time,$minit){
		$time = strtotime($time);
		$time = $time + ($minit * 60);
		return $time_final = date("H:i:s", $time);
	}

}//end of class
	
?>