<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

//ini_set('display_errors', 1);

class EtpViewController extends CI_Controller {

    public function __construct()
    {
		parent::__construct();
		$this->load->model('Common_model');
		$this->load->library('email');
		$this->load->model('EtpView_model');
    }

	public function etpview_list($msg=NULL)   ///dashboard for operator
	{
		if ($this->session->userdata('uid'))
		{
			$data['unit_list'] = $this->EtpView_model->getUnitListDropdown();
			$data['etpview_list'] = $this->EtpView_model->getEtpViewList();
			$this->load->view('etpview/etpview_list',$data);
		}
	}

	public function etpview_insert()
	{
		if ($this->session->userdata('uid'))
		{
			$name=trim($this->input->post('name'));
			$unit_id=trim($this->input->post('unit_id'));
			$id=trim($this->input->post('Id'));
			
			$data_insert = array(
				'name'=>$name,
				'unit_id'=>$unit_id,
				'created_at'=>CURRENT_DATETIME,
			);

			if($id !=''){
				$inserted_id = $this->Common_model->updateData("etpview","Id",$id,$data_insert);
				$inserted_id = $id;
			}else{
				$inserted_id = $this->Common_model->insertData("etpview",$data_insert);
			}

			if($id !=''){
				$msg = "Energy Meter Updated";
				$this->popupmsg($msg);
			}else{

				if($inserted_id !=''){
					$this->session->set_flashdata('success_message', 'Inserted success');
				}else{
					$this->session->set_flashdata('error_message', 'Inserted error');
				}

				redirect($_SERVER['HTTP_REFERER']);	
			}
		}	
	}

	public function etpview_edit()
	{
		if ($this->session->userdata('uid'))
        { 
        	$id = $this->input->get("id");
        	if($id !=''){
        		$data['p1'] = $id;
        		$data['edit_data'] = $this->Common_model->getIdWiseData("etpview","Id",$id);
        		$data['unit_list'] = $this->EtpView_model->getUnitListDropdown();
        		$this->load->view('etpview/edit_etpview',$data); 	
        	}
        }
        else
        {
        	redirect("/");
        }	
	}

	public function popupmsg($msg=NULL)
	{
		$p1=$msg;//msg
		$this->Common_model->down_check('PopupMsg',$p1,$p2=NULL,$p3=NULL,$p4=NULL,$p5=NULL,$p6=NULL,$p7=NULL,$p8=NULL,$p9=NULL,$p10=NULL,$p11=NULL,$p12=NULL,$p13=NULL,$p14=NULL,$p15=NULL);
	}

	public function etpselectlist_view()
	{
		$unit_id=$this->session->userdata('unit_id');
		$etpview_data = $this->Common_model->getIdWiseAllData("etpview","unit_id",$unit_id);
		$etp_data['etpview_data'] = $etpview_data;
		if(count($etpview_data) > 1){
			$this->load->view('etp/etp_select_list',$etp_data);
		}else{
			$this->session->set_userdata('etpview_id',$etp_data['etpview_data'][0]->Id);
			redirect("etp/dashboard_operator");
		}
	}

	public function etpselectaction_view($etpview_id)
	{
		$this->session->set_userdata('etpview_id',$etpview_id);
		redirect("etp/dashboard_operator");
	}
}

?>