<?php
defined("BASEPATH") or exit("No direct script access allowed");

class Login extends CI_Controller
{
    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     *	- or -
     * 		http://example.com/index.php/welcome/index
     *	- or -
     * Since this controller is set as the default controller in
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see https://codeigniter.com/user_guide/general/urls.html
     */
    public function __construct()
    {
        parent::__construct();
        //$this->clear_cache();
        $this->load->model("User_model");
        $this->load->model("Common_model");
    }
    //	//index page display..
    public function index($msg = null)
    {
        $p1 = $msg; //msg
        $this->load->model("Common_model");
        $this->Common_model->down_check(
            "Login",
            $p1,
            $p2 = null,
            $p3 = null,
            $p4 = null,
            $p5 = null,
            $p6 = null,
            $p7 = null,
            $p8 = null,
            $p9 = null,
            $p10 = null,
            $p11 = null,
            $p12 = null,
            $p13 = null,
            $p14 = null,
            $p15 = null
        );
    }

    ////function for login validation..
    function signin()
    {
        //$emailid= trim($this->input->post('emailid'));
        $userid = trim($this->input->post("userid"));
        $password = trim($this->input->post("password"));
        $query = $this->User_model->validate($userid, $password);
        $this->form_validation->set_rules(
            "userid",
            "User Id",
            "trim|required|min_length[2]|max_length[100]|xss_clean|callback_validateUser[" .
                $query->num_rows() .
                "]"
        );
        $this->form_validation->set_rules(
            "password",
            "Password",
            "required|min_length[6]|xss_clean|trim"
        );

        $this->form_validation->set_error_delimiters(
            '<div class="error">',
            "</div>"
        );
        $this->form_validation->set_message("required", "Enter %s");

        //check user exist or not..
        $usercheck = $this->Common_model->get_table_data(
            $fields = "userid,user_last_failed_login,user_failed_logins,status",
            $f1 = "userid",
            $v1 = $userid,
            $f2 = "",
            $v2 = "",
            $f3 = "",
            $v3 = "",
            $nf1 = "",
            $nv1 = "",
            $betf1 = "",
            $betv1 = "",
            $betv2 = "",
            $lf1 = "",
            $lf2 = "",
            $tablename = "users",
            $orderby = "",
            $orderbytype = "",
            $limitvalue = ""
        );
        $count = $usercheck->num_rows();

        if ($userid != "" && $password != "") {
            //check with email and password
            if ($count == 1) {
                foreach ($usercheck->result() as $row) {
                    $user_last_failed_login = $row->user_last_failed_login;
                    $countlogattempt = $row->user_failed_logins;
                    $user_status = $row->status;
                }
                date_default_timezone_set("Asia/Kolkata");
                $timeloginfailed = strtotime($user_last_failed_login);
                $timeloginfailed1 = strtotime("-60 minutes");
                $diff = $timeloginfailed1 - $timeloginfailed;
                // echo $diff;
                //if account is disabled..
                if ($user_status == 1 && $diff < 3600) {
                    $msg =
                        "Account is inActive, Login after 1 hr. or contact Admin!";
                    $this->index($msg);
                }else if($user_status == 1){
                	$msg =
                        "Account is inActive, Please contact Admin!";
                    $this->index($msg);
                } else {
                    if ($this->form_validation->run() == false) {
                        if ($countlogattempt == 5) {
                            $query1 = $this->User_model->processLogin(
                                $userid,
                                $password
                            );
                            $msg =
                                "6 incorrect login attempts, Account has been locked for One Hour.";
                            $this->index($msg);
                        } else {
                            $query1 = $this->User_model->processLogin(
                                $userid,
                                $password
                            );
                            $msg = "Login with registered userid and password!";
                            $this->index($msg);
                        }
                    }
                    //end of if ($this->form_validation->run() == FALSE)
                    else {
                        if ($diff > 3600 && $countlogattempt >= 6) {
                            $this->User_model->update_user_failed_login(
                                $userid
                            );
                            $msg =
                                "Account is Active Now login with your registered user id. and password !";
                            $this->index($msg);
                        } elseif ($countlogattempt < 6) {
                            //$query = $this->User_model->validate($user_name,$password);
                            if ($query) {
                                $usersdetail = $this->Common_model->get_table_data(
                                    $fields =
                                        "empid,unit_id,Id,uid,role,plant_id,status",
                                    $f1 = "userid",
                                    $v1 = $userid,
                                    $f2 = "",
                                    $v2 = "",
                                    $f3 = "",
                                    $v3 = "",
                                    $nf1 = "",
                                    $nv1 = "",
                                    $betf1 = "",
                                    $betv1 = "",
                                    $betv2 = "",
                                    $lf1 = "",
                                    $lf2 = "",
                                    $tablename = "users",
                                    $orderby = "",
                                    $orderbytype = "",
                                    $limitvalue = ""
                                );
                                foreach ($usersdetail->result() as $d1):
                                    $uid = $d1->Id; //autoid
                                    $unit_id = $d1->unit_id;
                                    $role = $d1->role;
                                    $empid = $d1->empid;
                                    $plant_id = $d1->plant_id;
                                endforeach;
                                $user = [
                                    "uid" => $uid,
                                    "role" => $role,
                                    "unit_id" => $unit_id,
                                    "empid" => $empid,
                                    "plant_id" => $plant_id,
                                ];
                                $this->session->set_userdata($user);
                                if ($role == 1) {
                                    //superadmin
                                    redirect("Dashboard/");
                                }
                                ///dashboard after login super
                                // else  if($role==2) //admin
                                // redirect('Dashboard/admin');  ///dashboard after login
                                elseif ($role == 2 || $role == 4) {
                                    //unit admin
                                    redirect("Dashboard/report");
                                }

                                ///admin unit
                                elseif ($role == 3) {
                                    //redirect('Dashboard/dashboard_operator');
                                    redirect("etp/dashboard_operator");
                                } elseif ($role == 5) {
                                    //redirect('Dashboard/dashboard_operator');
                                    redirect("Login/unit_list_select");
                                }

                                //else if($role==4)
                                //redirect('Dashboard/dashboard');  ///operator and viewer
                            } else {
                                $msg = "Kindly Enter Correct information !";
                                $this->index($msg);
                            }
                        } //end of  else if($status==0)
                    } //end of if query
                } //end of if ($countlogattempt<6  )
                // } //end of else
            }

            //end of count===1
            else {
                $msg = "Unregistered User Id. !";
                $this->index($msg);
            }
        } else {
            redirect("/");
        }
    }
    /** Custom Validation Method*/ // validateUser($username,$recordCount)
    public function validateUser($userid, $recordCount)
    {
        if ($recordCount != 0) {
            return true;
        } else {
            $this->form_validation->set_message(
                "validateUser",
                "Invalid %s or Your Password"
            );
            return false;
        }
    }

    //view of change password ...
    public function change_password($msg = null)
    {
        //$this->load->view('Change_password',$msg);
        $p1 = $msg; //msg
        $this->Common_model->down_check(
            "Change_password",
            $p1,
            $p2 = null,
            $p3 = null,
            $p4 = null,
            $p5 = null,
            $p6 = null,
            $p7 = null,
            $p8 = null,
            $p9 = null,
            $p10 = null,
            $p11 = null,
            $p12 = null,
            $p13 = null,
            $p14 = null,
            $p15 = null
        );
    }

    //action of change password
    public function action_change_password()
    {
        $password = trim($this->input->post("user_password_old"));
        $newpassword = trim($this->input->post("user_password_new"));
        $username = $this->session->userdata("user_name");
        $user_name = $this->session->userdata("user_name");
        $query = $this->User_model->validate($userid, $password);
        $this->form_validation->set_rules(
            "user_password_old",
            "Current Password",
            "trim|required|min_length[8]|xss_clean|callback_validateUser[" .
                $query->num_rows() .
                "]"
        );
        $this->form_validation->set_rules(
            "user_password_new",
            "New Password",
            "trim|required|min_length[8]|max_length[35]|xss_clean"
        );
        $this->form_validation->set_rules(
            "user_password_repeat",
            "Confirm Password",
            "trim|required|min_length[8]|max_length[35]|xss_clean|matches[user_password_new]"
        );
        //  $this->form_validation->set_rules('captcha', 'Security Code', 'trim|required|xss_clean|callback_check_captcha');

        if ($this->form_validation->run() == false) {
            $newdata = "";
            $this->change_password();
        } else {
            $this->Transaction_log_model->change_password_update(
                $user_name,
                $newpassword
            );

            $msg =
                "YOUR PASSWORD HAS BEEN CHANGED SUCCESSFULLY !  YOU WILL BE LOGGED OUT AUTOMATICALLY IN 5 SEC. KINDLY LOGIN AGAIN WITH YOUR NEW PASSWORD.<br> ( आपका पासवर्ड सफलतापूर्वक बदल दिया गया है ! आप पांच सेकेंड में स्वतः लॉग आउट हो जायेंगे ! कृपया अपने नए पासवर्ड से दोबारा लॉग इन करें| ) ";
            $this->change_password($msg);
        }
    }

    public function unit_list_select()
    {
        $data["unit_list"] = $this->Common_model->getUnitList("units");
        $this->load->view("unit_list_select", $data);
    }

    public function unitSelectAction($unit_id)
    {
        if ($unit_id != "") {
            $session_data = $this->session->userdata();
            $session_data["unit_id"] = $unit_id;
            $this->session->set_userdata($session_data);
            redirect("etp/daily-log-book");
        } else {
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }
} //end of class
