<?php 

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';

class UserController extends REST_Controller {

	protected $table_users = 'users';

	public function __construct()
	{  
		parent::__construct();
		$this->load->model('UserApiModel');
        $this->load->model('Common_model');
        $this->load->model('ImageUpload');
        $techfiles = array();
	}

	public function login_post()
    {
        try {

            $email = trim($this->input->post('email'));
            $password = trim($this->input->post('password'));
            $device_type = trim($this->input->post('device_type'));
            $device_token = trim($this->input->post('device_token'));

            if (isset($email) && $email != '' && $password !='')
            {
                $password_en = $this->Common_model->encrypt($password);
                $res = $this->UserApiModel->login_app($email, $password_en);
                
                if ($res)
                {   
                    /* header token code */
                    $tokenData = array();
                    $tokenData['id'] = 1; //TODO: Replace with data for token
                    $tokenData['timestamp'] = now();
                    
                    $token = AUTHORIZATION::generateToken($tokenData);
                    $user_id_en = $this->Common_model->encrypt($res->Id);
                    $Authorization = $token.$user_id_en;
                    $this->save_access_token($res->Id,$Authorization);
                    /* end header token code */

                    $this->save_device_token($res->Id,$device_type,$device_token);

                    $res->user_avatar = $res->user_avatar !='' ? site_url().IMAGES_UPLOAD_DISPLAY_PATH."profile_pic/".$res->user_avatar : site_url().IMAGES_UPLOAD_DISPLAY_PATH."user_avatar_default.png";

                    unset($res->password_hash);
                    $res->Authorization = $Authorization;

                    $status = "success";
                    $message = "Login Successfully.";
                    $techfiles = $res;
                }
                else
                {
                    $status = "error";
                    $message = "Username or password does not match.";
                    $techfiles = (object)$email;
                }
            }
            else
            {
                $status = "incomplete";
                $message = "Please fill all the mandatory fields.";
                $techfiles = (object)$email;
            }

            $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);
        }
        catch (exception $e) {
           
            $status = "error";
            $message = $e->getMessage()."-".$e->getLine();
            $techfiles = (object)$email;

            $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);
        }
    }
    
    public function logout_post(){

        $user_id = $this->input->post('user_id');
        $device_token = $this->input->post('device_token');
        $device_type = $this->input->post('device_type');
            
        if(isset($user_id) && $user_id != "")
        {
            $status = "success";
            $message = "Logout Successfully";
            $techfiles = array();

        }else{
            $status = 'incomplete';
            $message = 'Please complete all fields.';
            $techfiles = array();
        }
        // Response Json
        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);       
    }

    public function save_device_token($user_id,$device_type,$device_token)
    {   
        if($device_type == 'Android'){
            $update_token = array("device_android"=>$device_token);
        }
        if($device_type =='Iphone'){
            $update_token = array("device_iphone"=>$device_token);
        }
        if(isset($update_token) && $update_token !=''){
            $this->Common_model->updateData("users","Id",$user_id,$update_token);    
        }
    }
    
    public function save_access_token($user_id,$token){
        $res = $this->db->query("UPDATE users SET Authorization = '".$token."' WHERE Id = '".$user_id."'");
    }

    public function forgotpassword_post()
    {
    	$email = trim($this->input->post('email'));

        if (isset($email) && $email != '')
        {
            $user_data = $this->Common_model->getIdWiseData("users","emailid",$email); 
            if ($user_data)
            {  
            	$email_content = $this->EmailModel->getEmailContent('1');
            	$token = $this->Common_model->encrypt($user_data->Id);
            	$subject = $email_content->subject;
            	$password_link = site_url()."user/resetpassword?link=".$token;

            	$message = str_replace('%firstname%', $user_data->empname, str_replace('%link_reset%', $password_link, $email_content->message));

            	$res = $this->EmailModel->sendEmail($email,null,$subject,$message);

            	if($res){
            		$status = "success";
	                $message = "Please check your email to reset your password.";
	                $techfiles = $user_data;
            	}else{

	                $status = "error";
	                $message = "Something went wrong.";
	                $techfiles = (object)$email;
            	}
            }
            else
            {
            	$status = "error";
				$message = "This email not exits.";
				$techfiles = (object)$email;
            }
        }
        else
        {
        	$status = "incomplete";
			$message = "Please fill all the mandatory fields.";
			$techfiles = (object)$email;
        }

        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);
    }

    public function profileview_get()
    {
        $user_id = trim($this->input->get("user_id"));

        if(isset($user_id) && $user_id !='')
        {
            $headers = $this->input->request_headers();

            if (array_key_exists('Authorization', $headers) && !empty($headers['Authorization']))
            {
                $decodedToken = $this->Common_model->validateHeaderToken($headers['Authorization'],$user_id);

                if($decodedToken != false) 
                {
                    if(isset($decodedToken) && $decodedToken !='')
                    {
                        $decodedToken->user_avatar = $decodedToken->user_avatar !='' ? site_url().IMAGES_UPLOAD_DISPLAY_PATH."profile_pic/".$decodedToken->user_avatar : "";
                        unset($decodedToken->password_hash);
                        $status = "success";
                        $message = "Record found Successfully.";
                        $techfiles = $decodedToken;
                    }
                    else
                    {
                        $status = EMPTY_STATUS;
                        $message = "Record not found.";
                        $techfiles = (object)$user_id;
                    }
                }
                else
                {
                    $status = "invalid";
                    $message = SESSION_EXPIRE_MSG;
                    $techfiles = (object)$user_id;
                }
            }
            else
            {
                $status = "header request failed";
                $message = '';
                $techfiles =  (object)$user_id;
            }
        }
        else
        {
            $status = 'incomplete';
            $message = 'Please complete all fields.';
            $techfiles = (object)$user_id;
        }
        
        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);
    }

    public function editprofile_post()
    {
        $user_id = trim($this->input->post("user_id"));
        $firstname = trim($this->input->post("firstname"));
        $lastname = trim($this->input->post("lastname"));
        $user_avatar = trim($this->input->post("user_avatar"));

        if(isset($user_id) && $user_id !='')
        {
            $headers = $this->input->request_headers();

            if (array_key_exists('Authorization', $headers) && !empty($headers['Authorization'])) 
            {
                $decodedToken = $this->Common_model->validateHeaderToken($headers['Authorization'],$user_id);

                if($decodedToken != false) 
                {
                    $update_data = array("updated_date"=>CURRENT_DATETIME);

                    if(isset($_FILES['user_avatar']) && $_FILES['user_avatar'] !='')
                    {
                        $upload_path = IMAGES_UPLOAD_DISPLAY_PATH."profile_pic/";
                        $update_data['user_avatar'] = $this->ImageUpload->file_upload($upload_path,'user_avatar');
                    } 

                    $update_data['empname'] = $firstname." ".$lastname;

                    $up_res = $this->Common_model->updateData("users","Id",$user_id,$update_data);

                    if($up_res){

                        $res = $this->Common_model->getIdWiseData("users","Id",$user_id);

                        $res->user_avatar = $res->user_avatar !='' ? site_url().IMAGES_UPLOAD_DISPLAY_PATH."profile_pic/".$res->user_avatar : site_url().IMAGES_UPLOAD_DISPLAY_PATH."user_avatar_default.png";
                        
                        unset($res->password_hash);

                        $status = "success";
                        $message = "Profile updated successfully.";
                        $techfiles = $res;

                    }else{
                        
                        $status = "error";
                        $message = "Something went wrong.";
                        $techfiles = (object)$res;
                    }
                }
                else
                {
                    $status = "invalid";
                    $message = SESSION_EXPIRE_MSG;
                    $techfiles = (object)$user_id;
                }
            }
            else
            {
                $status = "header request failed";
                $message = '';
                $techfiles =  (object)$user_id;
            }
        }
        else
        {
            $status = 'incomplete';
            $message = 'Please complete all fields.';
            $techfiles = (object)$user_id;
        }
        
        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);   
    }

    public function changePassword_post()
    {
        $user_id = trim($this->input->post("user_id"));
        $oldpassword = trim($this->input->post('oldpassword'));
        $password = trim($this->input->post('password'));
        $password = $this->Common_model->encrypt($password);

        if(isset($user_id) && $user_id !='' && $oldpassword !='' && $password !='')
        {
            $headers = $this->input->request_headers();

            if (array_key_exists('Authorization', $headers) && !empty($headers['Authorization'])) 
            {
                $decodedToken = $this->Common_model->validateHeaderToken($headers['Authorization'],$user_id);

                if($decodedToken != false) 
                {
                    $oldpassword = $this->Common_model->encrypt($oldpassword);
                    
                    $oldpasswordcheck = $this->UserApiModel->oldpasswordcheck($user_id,$oldpassword);
                    
                    if(isset($oldpasswordcheck) && $oldpasswordcheck !='')
                    {
                        $update_data = array("updated_date"=>CURRENT_DATETIME,"password_hash"=>$password);

                        $up_res = $this->Common_model->updateData("users","Id",$user_id,$update_data);

                        if($up_res){

                            $status = "success";
                            $message = "Password changed successfully.";
                            $techfiles = array();

                        }else{
                            
                            $status = "error";
                            $message = "Something went wrong.";
                            $techfiles = array();
                        }
                    }
                    else
                    {
                        $status = "error";
                        $message = "Password does not match with current password.";
                        $techfiles = array(); 
                    }
                }
                else
                {
                    $status = "invalid";
                    $message = SESSION_EXPIRE_MSG;
                    $techfiles = array();
                }
            }
            else
            {
                $status = "header request failed";
                $message = '';
                $techfiles =  array();
            }
        }
        else
        {
            $status = 'incomplete';
            $message = 'Please complete all fields.';
            $techfiles = array();
        }
        
        $this->response(array('status'=>$status,'message'=>$message,'Root'=>$techfiles), 200);   
    }
}

?>