<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Etp_model extends CI_Model {

	public function __construct()
	{
		$this->UnitShiftConstant();//this function define shift constant
		parent::__construct();
	}

	public function UnitShiftConstant()
	{
		$unit_id=$this->session->userdata('unit_id');

		if($unit_id !=null){
			$this->db->where("unit_id",$unit_id);
		}
        $res = $this->db->get("units")->row();

        $Shift1_time = $res->Shift1_time !='' ? explode('-',$res->Shift1_time) : '';
        $Shift2_time = $res->Shift2_time !='' ? explode('-',$res->Shift2_time) : '';
        $Shift3_time = $res->Shift3_time !='' ? explode('-',$res->Shift3_time) : '';

        define("Shift_1_start", $Shift1_time !='' ? $Shift1_time[0] : '07:30');
        define("Shift_1_end", $Shift1_time !='' ? $Shift1_time[1] : '15:30');
        define("Shift_2_start", $Shift2_time !='' ? $Shift2_time[0] : '15:30');
        define("Shift_2_end", $Shift2_time !='' ? $Shift2_time[1] : '23:30');
        define("Shift_3_start", $Shift3_time !='' ? $Shift3_time[0] : '23:30');
        define("Shift_3_end", $Shift3_time !='' ? $Shift3_time[1] : '07:30');
	}

	public function getLocationDataWithStatus($user_id=null,$etpview_id=null)
	{
		$unit_id=$this->session->userdata('unit_id');

		$sql = "select * from sublocations where 1=1";
		$sql .=" AND unit_id = '".$unit_id."'";
		$sql .=" AND status !='1'";

		if($etpview_id !=null){
			$sql .=" AND etpview_id = '".$etpview_id."'";
		}

		$sql .=" AND deleted_at = '0000-00-00 00:00:00'";

		//$sql .=" ORDER BY name";
		$sql .=" ORDER BY arrival_in ASC";

		$sql_res = $this->db->query($sql);
		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getParameterWithLocation($array_arg=null)
	{
		$unit_id=$this->session->userdata('unit_id');

		$shift_current = $this->Etp_model->getActiveShiftName();

		$sql = "select pr.*,lo.name as location_name,lo.id as location_id from parameters pr INNER JOIN sublocations lo ON lo.id = pr.location_id where 1=1";

		if(isset($array_arg['location_id']) && $array_arg['location_id'] !='' && $array_arg['location_id'] !='All'){
			$sql .=" AND pr.location_id = '".$array_arg['location_id']."'";

			$sql .=" AND pr.status !='1'";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		$sql .=" AND pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."'";

		if($shift_current !=''){
			$sql .=" AND (pr.frequency_shift = '".$shift_current."' OR pr.frequency_shift = 'All Shift'  OR pr.frequency_shift = 'Once in A Day')";
		}

		if(isset($array_arg['etpview_id']) && $array_arg['etpview_id'] !='') {
			$sql .=" AND lo.etpview_id = '".$array_arg['etpview_id']."'";
		}

		$sql .=" AND pr.unit_id = '".$unit_id."'";

		$sql .=" ORDER BY pr.arrival_in ASC";

		$sql_res = $this->db->query($sql);
		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function checkCurrentValueRange($param_id,$current_value)
	{
		$sql = "SELECT * FROM `parameters` where Id = ".$param_id." AND ".$current_value." BETWEEN minrange AND maxrange";

		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return "false";
		}
	}

	public function insertCurrentValueParamAudit($arg_data)
	{
		$audit_date_time = $this->checkCurrentTimeShift3();
		$unit_id=$this->session->userdata('unit_id');

		$arg_data['unit_id'] = $unit_id;
		$arg_data['audit_date_time'] = $audit_date_time;
		$arg_data['created_at'] = CURRENT_DATETIME;//$audit_date_time
		$arg_data['updated_at'] = CURRENT_DATETIME;//$audit_date_time

		$this->db->insert('parameter_audits',$arg_data);
		return $this->db->insert_id();
	}

	function checkCurrentTimeShift3()
	{
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));
		//
		if(($current_time >= '00:00' && $current_time <= Shift_3_end)) {
			return $current_date = date ('Y-m-d H:i:s',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
		}else{
			return CURRENT_DATETIME;
		}
	}

	public function getParameterAuditDataModel($array_filter=null)
	{
		$role=$this->session->userdata('role'); 
  		$uid=$this->session->userdata('uid'); 
		$unit_id=$this->session->userdata('unit_id');
		$etpview_id_report=$this->session->userdata('etpview_id_report');

		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
		$days_ago = date('Y-m-d', strtotime('-7 days', strtotime(CURRENT_DATETIME)));

		$date_check_query = " AND DATE(pa.audit_date_time) BETWEEN '".$days_ago."' AND '".$current_date."'";


		$sql = "select pa.*,pr.name,pr.minrange,pr.maxrange,ur.userid,subl.name as sub_name from parameter_audits pa INNER JOIN parameters pr ON pr.Id = pa.parameter_id INNER JOIN users ur ON ur.Id = pa.uid INNER JOIN sublocations subl ON pa.location_id = subl.Id where 1=1";
		
		$sql .=" AND pa.unit_id = '".$unit_id."'";

		if($etpview_id_report !=null && $etpview_id_report !=''){
			$sql .=" AND subl.etpview_id = '".$etpview_id_report."'";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		//$sql .= $date_check_query;

		if($array_filter !=null)
		{
			if(isset($array_filter['filter_range']) && $array_filter['filter_range'] !='' && $array_filter['filter_range'] !='completed')
			{
				$sql .=" AND pa.range_status = 'out_range'";
			}

			if(isset($array_filter['updateView']))
			{
				$sql .=" AND pa.Id = ".$array_filter["updateView"]."";
			}

			if(isset($array_filter['fromDate']) && $array_filter['fromDate'] !=''  && isset($array_filter['toDate']) && $array_filter['toDate'] !='')
			{
				$fromDate = date("Y-m-d",strtotime($array_filter['fromDate']));
				$toDate = date("Y-m-d",strtotime($array_filter['toDate']));
				
				$sql.=" AND DATE(pa.audit_date_time) BETWEEN '".$fromDate."' AND '".$toDate."'";
			}

			if(isset($array_filter['frequency_value']) && $array_filter['frequency_value'] !='All')
			{
				$sql .=" AND pr.frequency = '".$array_filter['frequency_value']."'";
			}

			if(isset($array_filter['frequencyshift_value']) && $array_filter['frequencyshift_value'] !='All')
			{
				//$sql .=" AND pr.frequency_shift = '".$array_filter['frequencyshift_value']."'";

				if($array_filter['frequencyshift_value'] == 'Shift1'){
					$sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
					$sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
					$sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
				}else{}

				/*current date check */
	            $current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
	            $current_time = date("H:i",strtotime(CURRENT_DATETIME));
	            if($current_time >= '00:00' && $current_time <= Shift_3_end){
	                $current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
	            }
	            $audit_filter .=" AND (DATE(audit_date_time) = '".$current_date."')";
	            /* end */
			}
		}
        
        $sql .=" ORDER BY pa.Id DESC";
        
		//echo $sql;die();

		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getParameterAuditDataModelDailyBook($array_filter=null)
	{
		$role=$this->session->userdata('role'); 
  		$uid=$this->session->userdata('uid'); 
		$unit_id=$this->session->userdata('unit_id');

		$audit_filter = '';
		$parameter_filter = '';

		if($array_filter !=null)
		{
			if(isset($array_filter['etpview_id']) && $array_filter['etpview_id'] !='')
			{
				$parameter_filter .=" AND subl.etpview_id = '".$array_filter['etpview_id']."'";
			}

			if(isset($array_filter['fromDate']) && $array_filter['fromDate'] !='')
			{
				$fromDate = date("Y-m-d",strtotime($array_filter['fromDate']));

				//$audit_filter .=" AND DATE(pa.audit_date_time) = '".$fromDate."'";
				$audit_filter .=" AND (CASE WHEN pr.frequency = 'Monthy' THEN  DATE(pa.audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 MONTH AND '".$fromDate."' WHEN pr.frequency ='Weekly' THEN DATE(pa.audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 WEEK AND '".$fromDate."' WHEN pr.frequency = 'Daily' THEN DATE(pa.audit_date_time) = '".$fromDate."' ELSE '' END)";
			}

			if(isset($array_filter['frequency_value']) && $array_filter['frequency_value'] !='All')
			{
				$parameter_filter .=" AND pr.frequency = '".$array_filter['frequency_value']."'";
			}

			if(isset($array_filter['frequencyshift_value']) && $array_filter['frequencyshift_value'] !='All')
			{
				if($array_filter['frequencyshift_value'] == 'Shift1'){
					$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
					$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
					$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
				}elseif($array_filter['frequencyshift_value'] == 'Once in A Day'){

					$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
					$current_time = date("H:i",strtotime(CURRENT_DATETIME));
					
					if($current_time >= '00:00' && $current_time <= Shift_3_end){
						$current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
					}

					$audit_filter .=" AND (DATE(audit_date_time) = '".$current_date."')";
				}else{}

				if($array_filter['frequencyshift_value'] == 'Once in A Day'){

					$parameter_filter .=" AND (pr.frequency_shift = '".$array_filter['frequencyshift_value']."')";

				}else{

					$parameter_filter .=" AND (pr.frequency_shift = '".$array_filter['frequencyshift_value']."' OR pr.frequency_shift = 'All Shift')";
				}
			}
		}

		$sql = "select pr.*,pa.current_value,pa.current_value_new,pa.audit_date_time,pa.range_status,pa.Id as audit_id,ur.userid,subl.name as sub_name,subl.etpview_id as etpview_id from parameters pr LEFT JOIN parameter_audits pa ON (pr.Id = pa.parameter_id ".$audit_filter.") LEFT JOIN users ur ON ur.Id = pa.uid INNER JOIN sublocations subl ON pr.location_id = subl.Id where 1=1 ".$parameter_filter."";

		$sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";
		
		if($unit_id !=''){
			$sql .=" AND (pr.unit_id = '".$unit_id."')";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		if(isset($array_filter['unit_id']) && $array_filter['unit_id'] !=''){
			$sql .=" AND (pr.unit_id = '".$array_filter['unit_id']."')";
		}

		$sql .=" AND pr.status !='1'";

		$sql .=" AND subl.status !='1'";
		
        //$sql .=" group by pr.Id ORDER BY pa.Id DESC";

		$sql .=" group by pr.Id ORDER BY subl.arrival_in ASC";
        
		$sql_res = $this->db->query($sql);

		//$this->db->last_query();die();

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getActiveShiftName()
	{
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));

	    if((($current_time >= Shift_3_start && $current_time <= '23:59') || $current_time >= '00:00' && $current_time <= Shift_3_end)) {
	      $shift_current = "Shift3";
	    }else if($current_time >= Shift_2_start && $current_time < Shift_2_end){
	      $shift_current = "Shift2";
	    }else if($current_time >= Shift_1_start && $current_time < Shift_1_end){
	      $shift_current = "Shift1";
	    }else{
	      $shift_current = "";
	    }

	    return $shift_current;
	}

	public function getIdWiseData($table,$fieldname,$id,$unit_id=null)
	{
		if($unit_id !=null){
			$this->db->where("unit_id",$unit_id);
		}
        $this->db->where($fieldname, $id);
        $res = $this->db->get($table)->row();
        return $res;
	}

	public function getTableData($table,$unit_id=null)
	{
		if($unit_id !=null){
			$this->db->where("unit_id",$unit_id);
		}
        $res = $this->db->get($table);
        if($res->row() > 0){
        	return $res->result();
        }else{
        	return "";
        }
	}

	public function insertData($table, $data)
    {
        $this->db->set($data);
        $this->db->insert($table, $data);
        return $this->db->insert_id();
    }

	public function updateData($table, $id_field_name, $id, $data)
    {
        $this->db->where($id_field_name, $id);
        $this->db->update($table, $data);
        return true;
    }

	public function getIdWiseAllData($table,$fieldname,$id,$unit_id=null)
	{
		if($unit_id !=null){
			$this->db->where("unit_id",$unit_id);
		}
		$this->db->where($fieldname, $id);
        $res = $this->db->get($table);
        if($res->row() > 0){
        	return $res->result();
        }else{
        	return "";
        }
	}
	
	public function checkLocationAuditStatus($location_id,$parameter_id=null)
	{
		$uid=$this->session->userdata('uid'); 

		$this->db->where("startdate <= ", date('Y-m-d',strtotime(CURRENT_DATETIME)));
		$this->db->where("enddate >= ", date('Y-m-d',strtotime(CURRENT_DATETIME)));
		$this->db->where("location_id", $location_id);
		$this->db->where("status !=",1);
		$this->db->where("deleted_at","0000-00-00 00:00:00");
		
		if($parameter_id !=null)
		{
			$this->db->where("Id",$parameter_id);
		}

        $res = $this->db->get("parameters");

        //echo $this->db->last_query();die();
        
        if($res->num_rows() > 0){

        	$result = $res->result();

        	$data = array();

        	foreach ($result as $key => $value) {
        		
        		/*if($value->frequency == 'Daily')
        		{
        			$data[] = $this->CheckFrequencyEntryDaily($value->Id);
        		}
        		else if($value->frequency == 'Monthly')
        		{
        			$param_data = $this->getLastMonthlyAuditUser($value->Id,$uid);

        			if($param_data !=''){
        				$startdate = date('Y-m-d',strtotime($param_data->audit_date_time));
        			}else{
	        			$startdate = $value->startdate;
        			}
        			
        			$data[] = $this->CheckFrequencyEntryMonthy($value->Id,$startdate);

        		}else if($value->frequency == 'Every Shift'){

					$data[] = $this->CheckFrequencyEntryEveryShift($value->Id);

        			//$data[] = "pending";
        		}*/

        		$data[] = $this->CheckFrequencyEntryShiftWise($value->Id,$value->frequency,$value->frequency_shift,$value->startdate);
        		
        	}

        	if(in_array("pending",$data))
        	{
        		return "status_pending";
        	}
        	else
        	{
        		return "status_done";
        	}

        }else{
        	return "status_done";
        }
	}

	function getLastMonthlyAuditUser($parameter_id,$uid)
	{
		$sql = $this->db->query("select * from parameter_audits where parameter_id = '".$parameter_id."' order by Id DESC");

		if($sql->num_rows() > 0)
		{
			$res = $sql->result()[0];
			return $res;
		}
		else
		{
			return "";
		}
	}
	
	function CheckFrequencyEntryShiftWise($param_id,$frequency,$frequency_shift,$startdate)
	{
		/*Shift 1 = 7AM - 3PM
		Shift 2 = 3PM - 11PM
		Shift 3 = 11PM - 7AM*/

		$uid=$this->session->userdata('uid');
		
		$array_shift = array(Shift_1_start."-".Shift_1_end,Shift_2_start."-".Shift_2_end,Shift_3_start."-".Shift_3_end);
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));
		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));

		//$current_time = '15:00';

		if($frequency == 'Daily'){
			$frequency_query = " AND date(created_at) = '".$current_date."'";
		}else if($frequency =='Monthly'){
			$param_data = $this->getLastMonthlyAuditUser($param_id,$uid);
			if($param_data !=''){
				$startdate = date('Y-m-d',strtotime($param_data->audit_date_time));
			}
			$enddate = date('Y-m-d', strtotime('+1 month', strtotime($startdate)));
			$frequency_query = " AND date(created_at) BETWEEN '".$startdate."' AND '".$enddate."'";
		}else if($frequency == 'Weekly'){
			$param_data = $this->getLastMonthlyAuditUser($param_id,$uid);
			if($param_data !=''){
				$startdate = date('Y-m-d',strtotime($param_data->audit_date_time));
			}
			$enddate = date('Y-m-d', strtotime('+1 week', strtotime($startdate)));
			$frequency_query = " AND date(created_at) BETWEEN '".$startdate."' AND '".$enddate."'";
		}else{ $frequency = ''; }

		if((($current_time >= Shift_3_start && $current_time <= '23:59') || $current_time >= '00:00' && $current_time <= Shift_3_end) && ($frequency_shift == 'Shift3' || $frequency_shift =='All Shift')) {

			if($current_time >= Shift_3_start && $current_time <= '23:59'){
				$array_shift[2] = Shift_3_start.'-23:59';
			}else{
				$array_shift[2] = "00:00-".Shift_3_end;
				$current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
			}

			$time = explode('-', $array_shift[2]);

			$sql = "SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."'";

			if($frequency == 'Daily'){
				//$sql .=" AND date(created_at) = '".$current_date."'";
				$sql .=" AND date(audit_date_time) = '".$current_date."'";
			}else{
				$sql .= $frequency_query;
			}
			
			//echo $this->db->last_query();

			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_2_start && $current_time < Shift_2_end && ($frequency_shift == 'Shift2' || $frequency_shift =='All Shift')){
			
			$time = explode('-', $array_shift[1]);

			$sql = "SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."'";

			$sql .= $frequency_query;

			//echo $this->db->last_query();

			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_1_start && $current_time < Shift_1_end && ($frequency_shift == 'Shift1' || $frequency_shift =='All Shift')){
			
			$time = explode('-', $array_shift[0]);

			$sql = "SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."'";

			$sql .= $frequency_query;
			
			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($frequency_shift == 'Once in A Day'){

			$sql = "SELECT * FROM parameter_audits where parameter_id = ".$param_id."";

			if($current_time >= '00:00' && $current_time <= Shift_3_end){
				$current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
			}

			$sql .=" AND date(audit_date_time) = '".$current_date."'";
			
			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}

		}else{
			$data = 'done';
		}		

    	return $data;
	}

	//not used
	function CheckFrequencyEntryDaily($parameter_id)
	{
		$uid=$this->session->userdata('uid'); 

		$sql = $this->db->query("select * from parameter_audits where parameter_id = '".$parameter_id."' AND date(audit_date_time) = '".date("Y-m-d",strtotime(CURRENT_DATETIME))."'");

		//echo $this->db->last_query();

		if($sql->num_rows() > 0)
		{
			return "done";
		}
		else
		{
			return "pending";
		}
	}
	//not used
	function CheckFrequencyEntryMonthy($parameter_id,$startdate)
	{
		$uid=$this->session->userdata('uid'); 
		$enddate = date('Y-m-d', strtotime('+1 month', strtotime($startdate)));

		$sql = $this->db->query("select * from parameter_audits where parameter_id = '".$parameter_id."' AND date(audit_date_time) BETWEEN '".$startdate."' AND '".$enddate."'");

		//echo $this->db->last_query();

		if($sql->num_rows() > 0)
		{
			return "done";
		}
		else
		{
			return "pending";
		}
	}

	

	function getLastSubmittedValueAudit($table,$fieldname,$id)
	{
		$this->db->where($fieldname, $id);
		$this->db->order_by("Id","DESC");
        $res = $this->db->get($table)->row();
        return $res;
	}

	/*function CheckFrequencyEntryEveryShift($param_id)
	{
		//Shift 1 = 7AM - 3PM
		//Shift 2 = 3PM - 11PM
		//Shift 3 = 11PM - 7AM

		$array_shift = array(Shift_1_start."-".Shift_1_end,Shift_2_start."-".Shift_2_end,Shift_3_start."-".Shift_3_end);
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));
		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));

		//$current_time = '15:00';

		if(($current_time >= Shift_3_start && $current_time <= '23:59') || $current_time >= '00:00' && $current_time <= '07:00'){

			if($current_time >= '23:00' && $current_time <= '23:59'){
				$array_shift[2] = '23:00-23:59';
			}else{
				$array_shift[2] = "00:00-07:00";
				$current_date = date ('Y-m-d',strtotime('+1 day', strtotime(CURRENT_DATETIME)));
			}

			$time = explode('-', $array_shift[2]);

			$sql = $this->db->query("SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."' AND date(created_at) = '".$current_date."'");

			//echo $this->db->last_query();

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_2_start && $current_time < Shift_2_end){
			
			$time = explode('-', $array_shift[1]);

			$sql = $this->db->query("SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."' AND date(created_at) = '".$current_date."'");

			//echo $this->db->last_query();

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_1_start && $current_time < Shift_1_end){
			
			$time = explode('-', $array_shift[0]);

			$sql = $this->db->query("SELECT * FROM parameter_audits where parameter_id = ".$param_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."' AND date(created_at) = '".$current_date."'");

			//echo $this->db->last_query();

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else{
			$data = '';
		}		

    	return $data;
	}*/

	function getPlantAdminEmail($plant_id){
		$query = $this->db->query("SELECT ifnull(GROUP_CONCAT(emailid),'') as admin_email FROM `employees` where plant_id = ".$plant_id."  AND Id IN (select empid from users where (role = 2 OR role = 4))");
		if($query->num_rows() > 0){
			return $email = $query->row()->admin_email;
		}else{
			return false;
		}
	}

	public function sendOutRangeEmailAdmin($array_arg){
		
		//$uid = $array_arg['uid'];

		if($array_arg['plant_id'] !=null && $array_arg['plant_id'] !=''){
			$to = $this->getPlantAdminEmail($array_arg['plant_id']);
			if(empty($to)){
				$to = array('nishant.srivastav@designx.in');
			}else{
				$to = array_values(array_filter(explode(',', $to)));
			}
		}else{
			$to = array('nishant.srivastav@designx.in');
		}

		//$to = array('megha.sharma@unilever.com','nishant.srivastav@designx.in');

		$from= "donotreply@techfilessolutions.in";
		$subject = 'Parameter Audit Current Value Out Range';

		$userdata = $this->Etp_model->getIdWiseData("users","Id",$array_arg['uid']);
		$username = ($userdata !='') ? $userdata->userid : '';
		
		$parameterdata = $this->Etp_model->getIdWiseData("parameters","Id",$array_arg['parameter_id']);
		$paramname = ($parameterdata !='') ? $parameterdata->name : '';

		$message = "<p>Hello Admin</p>";
		$message .= "<p>Here is out range Audit Submitted</p>";

		$message .="<p>User Name = ".$username."</p>";
		$message .="<p>Parameter Name = ".$paramname."</p>";
		$message .= "<p>Current Value = ".$array_arg['current_value']."</p>";
		$message .="<p>Min Range = ".$array_arg['minrange']."</p>";
		$message .="<p>Max Range = ".$array_arg['maxrange']."</p>";

		$message .="<p>You can check whole report of audit using below link.</p>";
		$message .="<a href='".site_url()."etp/report/report_parameter_audit'>".site_url()."Dashboard/report_parameter_audit</a>";

		$res = $this->Common_model->sendemail($from,$to,$message,$subject);

		if($res)
            echo"Congragulation Email Send Successfully.";
        else
          echo"email_sent","You have encountered an error";
	}

	public function getSublocationList($table)
	{
		$unit_id=$this->session->userdata('unit_id');
		$etpview_id_report=$this->session->userdata('etpview_id_report');

		if($etpview_id_report !=null && $etpview_id_report !=''){
			$this->db->where("etpview_id",$etpview_id_report);
		}
		
		$this->db->where("deleted_at","0000-00-00 00:00:00");
		$this->db->where("unit_id",$unit_id);
		$this->db->where("status !=",1);
        $res = $this->db->get($table);
        if($res->row() > 0){
        	return $res->result();
        }else{
        	return "";
        }
	}

	function minusMinitFromTime($time,$minit){
		$time = strtotime($time);
		$time = $time - ($minit * 60);
		return $time_final = date("H:i", $time);
	}

	function plusMinitFromTime($time,$minit){
		$time = strtotime($time);
		$time = $time + ($minit * 60);
		return $time_final = date("H:i", $time);
	}

	function getUnitViewerEmail($unit_id){
		$query = $this->db->query("SELECT ifnull(GROUP_CONCAT(emailid),'') as admin_email FROM `users` where unit_id = ".$unit_id."  AND role = 4 AND status = 0");
		if($query->num_rows() > 0){
			return $email = $query->row()->admin_email;
		}else{
			return false;
		}
	}

	//not used
	public function sendDailyLogBookCronMail($shift_type,$message_table=null,$unit_id=null,$unit_name=null)
	{
		//'megha.sharma@unilever.com','nishant.srivastav@designx.in','dinesh.patil@unilever.com'

		//$to = array('anukritika.jha@unilever.com','megha.sharma@unilever.com','nishant.srivastav@designx.in','dinesh.patil@unilever.com','deep.sheth@designx.in');

		$email_unit_viewer = $this->getUnitViewerEmail($unit_id);

		$to = $email_unit_viewer !='' ? $email_unit_viewer : 'deep.sheth@designx.in';

		//$to = array('kiran.suthar@designx.in');

		$from= "donotreply@techfilessolutions.in";
		$subject = 'Digital Environ report - '.$unit_name." - ".$shift_type;

		$message = "<p>Hello Admin</p>";
		$message .= "<p>Here is daily log book report.</p>";

		//$message .="<p>Click below link to view audit report.</p><br>";
		
		//$message .="<a href='".site_url()."etp/daily-log-book'>".site_url()."etp/daily-log-book</a>";

		if($message_table !=null){
			$message .= $message_table;
		}

		$res = $this->Common_model->sendemail($from,$to,$message,$subject);

		if($res){
			return true;
		}else{
			return false;
		}
	}

	/* out range email send */
	public function sendOutRangeEmailToViewer($arg_pass)
	{		
		$out_range_data = $this->getOutRangeAuditParameters($arg_pass['id']);

		if($out_range_data !='' && !empty($out_range_data))
		{
			$email_unit_viewer = $this->getUnitViewerEmail($arg_pass['unit_id']);
			$to = $email_unit_viewer !='' ? $email_unit_viewer : 'deep.sheth@designx.in';
			//$to = array('kiran.suthar@designx.in','deep.sheth@designx.in');
			$shift_current = $this->Etp_model->getActiveShiftName();
			$unit_data = $this->Common_model->getIdWiseData("units","unit_id",$arg_pass['unit_id']);
			$unit_name = $unit_data->name;

			$data['frequencyshift_value'] = $shift_current;
			$data['unit_name'] = $unit_name;
			$data['param_audit_data'] = $out_range_data;
			$message_table = $this->load->view('daily_log_book/email_parameter_outrange',$data,true);

			$from= "donotreply@techfilessolutions.in";
			$subject = 'Digital Environ Out Range Report - '.$unit_name." - ".$shift_current;
			$message = 'Digital Environ Out Range Report - '.$unit_name." - ".$shift_current;
			if($message_table !=null){
				$message .= $message_table;
			}

			$res = $this->Common_model->sendemail($from,$to,$message,$subject);

			if($res){
				return true;
			}else{
				return false;
			}
		}
	}
	
	public function getOutRangeAuditParameters($id_arr)
	{
		$this->db->select("pr.*,pa.name as name,sub.name as sub_name,ur.userid");
		$this->db->from("parameter_audits pr");
		$this->db->join("parameters pa","pa.Id = pr.parameter_id");
		$this->db->join("sublocations sub","sub.Id = pr.location_id");
		$this->db->join("users as ur","ur.Id = pr.uid");
		$this->db->where_in("pr.Id",$id_arr);
		$this->db->where("pr.range_status","out_range");
		$this->db->group_by("pr.Id");
        $res = $this->db->get("parameter_audits");

        //echo $this->db->last_query();die();

        if($res->row() > 0){
        	return $res->result();
        }else{
        	return array();
        }
	}

	/* end out range email send */

	//end of class...

}

?>