<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class WaterMeter_model extends CI_Model {

	public function __construct()
	{
		$this->Etp_model->UnitShiftConstant();//this function define shift constant
		parent::__construct();
	}

	function deleteWaterMeterData($id)
	{	
		//$this->db->query("DELETE FROM water_meter where Id = ".$id."");
		//$this->db->query("DELETE FROM parameter_audits where parameter_id = ".$id."");
		$this->db->query("UPDATE water_meter SET deleted_at = '".CURRENT_DATETIME."'  where Id = ".$id."");
	}

	public function getWaterMeterList($unit_id)
	{
		if($unit_id !=null){
			$this->db->where("unit_id",$unit_id);
		}
		$this->db->where("status !=",1);
		$this->db->where("deleted_at","0000-00-00 00:00:00");

        $res = $this->db->get("water_meter")->result();
        return $res;
	}

	public function getLocationDataWithStatus($user_id=null)
	{
		$unit_id=$this->session->userdata('unit_id');

		$sql = "select * from water_meter where 1=1";
		$sql .=" AND unit_id = '".$unit_id."'";
		$sql .=" AND status !='1'";
		$sql .=" AND deleted_at = '0000-00-00 00:00:00'";
		
		$sql .=" GROUP BY Id";
		$sql .=" ORDER BY name";

		$sql_res = $this->db->query($sql);
		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getWaterMeterWithLocation($array_arg=null)
	{
		$unit_id=$this->session->userdata('unit_id');

		$shift_current = $this->Etp_model->getActiveShiftName();

		$sql = "select pr.* from water_meter pr where 1=1";

		if(isset($array_arg['location_id']) && $array_arg['location_id'] !='' && $array_arg['location_id'] !='All'){
			$sql .=" AND pr.Id = '".$array_arg['location_id']."'";

			$sql .=" AND pr.status !='1'";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		$sql .=" AND pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."'";

		if($shift_current !=''){
			$sql .=" AND (pr.frequency_shift = '".$shift_current."' OR pr.frequency_shift = 'All Shift' OR pr.frequency_shift = 'Once in A Day')";
		}

		$sql .=" AND pr.unit_id = '".$unit_id."'";

		$sql .=" ORDER BY name";

		$sql_res = $this->db->query($sql);
		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function insertCurrentValueWaterMeterAudit($arg_data)
	{
		$audit_date_time = $this->checkCurrentTimeShift3();
		$unit_id=$this->session->userdata('unit_id');

		$arg_data['unit_id'] = $unit_id;
		$arg_data['audit_date_time'] = $audit_date_time;
		$arg_data['created_at'] = CURRENT_DATETIME;//$audit_date_time
		$arg_data['updated_at'] = CURRENT_DATETIME;//$audit_date_time

		$this->db->insert('water_meter_audits',$arg_data);
		return $this->db->insert_id();
	}

	function checkCurrentTimeShift3()
	{
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));
		//
		if(($current_time >= '00:00' && $current_time <= Shift_3_end)) {
			return $current_date = date ('Y-m-d H:i:s',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
		}else{
			return CURRENT_DATETIME;
		}
	}

	public function getWaterMeterAuditDataModel($array_filter=null)
	{
		$role=$this->session->userdata('role'); 
  		$uid=$this->session->userdata('uid'); 
		$unit_id=$this->session->userdata('unit_id');

		$sql = "select pa.*,pr.name,ur.userid,pr.location_name from water_meter_audits pa INNER JOIN water_meter pr ON pr.Id = pa.water_m_id INNER JOIN users ur ON ur.Id = pa.uid where 1=1";
		
		$sql .=" AND pa.unit_id = '".$unit_id."'";

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";

		if($array_filter !=null)
		{

			if(isset($array_filter['updateView']))
			{
				$sql .=" AND pa.Id = ".$array_filter["updateView"]."";
			}

			if(isset($array_filter['fromDate']) && $array_filter['fromDate'] !='')
			{
				$fromDate = date("Y-m-d",strtotime($array_filter['fromDate']));

				$sql .=" AND DATE(pa.audit_date_time) = '".$fromDate."'";

				//$toDate = date("Y-m-d",strtotime($array_filter['toDate']));

				//$sql.=" AND DATE(pa.audit_date_time) BETWEEN '".$fromDate."' AND '".$toDate."'";
			}

			if(isset($array_filter['frequency_value']) && $array_filter['frequency_value'] !='All')
			{
				$sql .=" AND pr.frequency = '".$array_filter['frequency_value']."'";
			}

			if(isset($array_filter['frequencyshift_value']) && $array_filter['frequencyshift_value'] !='All')
			{

				if($array_filter['frequencyshift_value'] == 'Shift1'){
					$sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
					$sql .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
					$sql .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
				}elseif($array_filter['frequencyshift_value'] == 'Once in A Day'){

					$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));
					$current_time = date("H:i",strtotime(CURRENT_DATETIME));
					
					if($current_time >= '00:00' && $current_time <= Shift_3_end){
						$current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
					}

					$audit_filter .=" AND (DATE(audit_date_time) = '".$current_date."')";
				}
			}

			if(isset($array_filter['water_meter_id']) && $array_filter['water_meter_id'] !='' && $array_filter['water_meter_id'] !='All')
			{
				$sql .=" AND pa.water_m_id = '".$array_filter['water_meter_id']."'";
			}
		}
        
        $sql .=" ORDER BY pa.created_at ASC";
        
		//echo $sql;

		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}

	public function getParameterAuditDataModelDailyBook($array_filter=null)
	{
		$role=$this->session->userdata('role'); 
  		$uid=$this->session->userdata('uid'); 
		$unit_id=$this->session->userdata('unit_id');

		$audit_filter = '';
		$parameter_filter = '';

		if($array_filter !=null)
		{
			if(isset($array_filter['fromDate']) && $array_filter['fromDate'] !='')
			{
				$fromDate = date("Y-m-d",strtotime($array_filter['fromDate']));

				//$audit_filter .=" AND DATE(pa.audit_date_time) = '".$fromDate."'";
				$audit_filter .=" AND (CASE WHEN pr.frequency = 'Monthy' THEN  DATE(pa.audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 MONTH AND '".$fromDate."' WHEN pr.frequency ='Weekly' THEN DATE(pa.audit_date_time) BETWEEN DATE('".$fromDate."') - INTERVAL 1 WEEK AND '".$fromDate."' WHEN pr.frequency = 'Daily' THEN DATE(pa.audit_date_time) = '".$fromDate."' ELSE '' END)";
			}

			if(isset($array_filter['frequency_value']) && $array_filter['frequency_value'] !='All')
			{
				$parameter_filter .=" AND pr.frequency = '".$array_filter['frequency_value']."'";
			}

			if(isset($array_filter['frequencyshift_value']) && $array_filter['frequencyshift_value'] !='All')
			{
				if($array_filter['frequencyshift_value'] == 'Shift1'){
					$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_1_start."' AND '".Shift_1_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift2'){
					$audit_filter .=" AND TIME(audit_date_time) BETWEEN '".Shift_2_start."' AND '".Shift_2_end."'";
				}elseif($array_filter['frequencyshift_value'] == 'Shift3'){
					$audit_filter .=" AND ((TIME(audit_date_time) BETWEEN '".Shift_3_start."' AND '23:59') OR (TIME(audit_date_time) BETWEEN '00:00' AND '".Shift_3_end."'))";
				}

				$parameter_filter .=" AND (pr.frequency_shift = '".$array_filter['frequencyshift_value']."' OR pr.frequency_shift = 'All Shift')";
			}
		}

		$sql = "select pr.*,pa.current_value,pa.current_value_new,pa.audit_date_time,pa.range_status,pa.Id as audit_id,ur.userid,subl.name as sub_name from parameters pr LEFT JOIN parameter_audits pa ON (pr.Id = pa.parameter_id ".$audit_filter.") LEFT JOIN users ur ON ur.Id = pa.uid INNER JOIN sublocations subl ON pr.location_id = subl.Id where 1=1 ".$parameter_filter."";

		$sql .=" AND (pr.startdate <= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."' AND pr.enddate >= '".date('Y-m-d',strtotime(CURRENT_DATETIME))."')";
		
		if($unit_id !=''){
			$sql .=" AND (pr.unit_id = '".$unit_id."')";
		}

		$sql .=" AND pr.deleted_at = '0000-00-00 00:00:00'";
		
        $sql .=" group by pr.Id ORDER BY pa.Id DESC";
        
		$sql_res = $this->db->query($sql);

		if($sql_res->num_rows() > 0){
			return $sql_res->result();
		}else{
			return array();
		}
	}
	
	public function checkLocationAuditStatus($location_id,$water_id=null)
	{
		$uid=$this->session->userdata('uid'); 

		$this->db->where("startdate <= ", date('Y-m-d',strtotime(CURRENT_DATETIME)));
		$this->db->where("enddate >= ", date('Y-m-d',strtotime(CURRENT_DATETIME)));
		$this->db->where("Id", $location_id);
		$this->db->where("status !=",1);

		if($water_id !=null)
		{
			$this->db->where("Id",$water_id);
		}

        $res = $this->db->get("water_meter");

        //echo $this->db->last_query();die();
        
        if($res->num_rows() > 0){

        	$result = $res->result();

        	$data = array();

        	foreach ($result as $key => $value) {
        		
        		$data[] = $this->CheckFrequencyEntryShiftWise($value->Id,$value->frequency,$value->frequency_shift,$value->startdate);
        		
        	}
        	
        	if(in_array("pending",$data))
        	{
        		return "status_pending";
        	}
        	else
        	{
        		return "status_done";
        	}

        }else{
        	return "status_done";//
        }
	}

	function getLastMonthlyAuditUser($water_m_id,$uid)
	{
		$sql = $this->db->query("select * from water_meter_audits where water_m_id = '".$water_m_id."' order by Id DESC");

		if($sql->num_rows() > 0)
		{
			$res = $sql->result()[0];
			return $res;
		}
		else
		{
			return "";
		}
	}
	
	function CheckFrequencyEntryShiftWise($water_id,$frequency,$frequency_shift,$startdate)
	{
		/*Shift 1 = 7AM - 3PM
		Shift 2 = 3PM - 11PM
		Shift 3 = 11PM - 7AM*/

		$uid=$this->session->userdata('uid');
		
		$array_shift = array(Shift_1_start."-".Shift_1_end,Shift_2_start."-".Shift_2_end,Shift_3_start."-".Shift_3_end);
		$current_time = date("H:i",strtotime(CURRENT_DATETIME));
		$current_date = date("Y-m-d",strtotime(CURRENT_DATETIME));

		//$current_time = '15:00';

		if($frequency == 'Daily'){
			$frequency_query = " AND date(created_at) = '".$current_date."'";
		}else if($frequency =='Monthly'){
			$water_data = $this->getLastMonthlyAuditUser($water_id,$uid);
			if($water_data !=''){
				$startdate = date('Y-m-d',strtotime($water_data->audit_date_time));
			}
			$enddate = date('Y-m-d', strtotime('+1 month', strtotime($startdate)));
			$frequency_query = " AND date(created_at) BETWEEN '".$startdate."' AND '".$enddate."'";
		}else if($frequency == 'Weekly'){
			$water_data = $this->getLastMonthlyAuditUser($water_id,$uid);
			if($water_data !=''){
				$startdate = date('Y-m-d',strtotime($water_data->audit_date_time));
			}
			$enddate = date('Y-m-d', strtotime('+1 week', strtotime($startdate)));
			$frequency_query = " AND date(created_at) BETWEEN '".$startdate."' AND '".$enddate."'";
		}else{ $frequency = ''; }

		if((($current_time >= Shift_3_start && $current_time <= '23:59') || $current_time >= '00:00' && $current_time <= Shift_3_end) && ($frequency_shift == 'Shift3' || $frequency_shift =='All Shift')) {

			if($current_time >= Shift_3_start && $current_time <= '23:59'){
				$array_shift[2] = Shift_3_start.'-23:59';
			}else{
				$array_shift[2] = "00:00-".Shift_3_end;
				$current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
			}

			$time = explode('-', $array_shift[2]);

			$sql = "SELECT * FROM water_meter_audits where water_m_id = ".$water_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."'";

			if($frequency == 'Daily'){
				//$sql .=" AND date(created_at) = '".$current_date."'";
				$sql .=" AND date(audit_date_time) = '".$current_date."'";
			}else{
				$sql .= $frequency_query;
			}
			
			//echo $this->db->last_query();

			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_2_start && $current_time < Shift_2_end && ($frequency_shift == 'Shift2' || $frequency_shift =='All Shift')){
			
			$time = explode('-', $array_shift[1]);

			$sql = "SELECT * FROM water_meter_audits where water_m_id = ".$water_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."'";

			$sql .= $frequency_query;

			//echo $this->db->last_query();

			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($current_time >= Shift_1_start && $current_time < Shift_1_end && ($frequency_shift == 'Shift1' || $frequency_shift =='All Shift')){
			
			$time = explode('-', $array_shift[0]);

			$sql = "SELECT * FROM water_meter_audits where water_m_id = ".$water_id." AND TIME(created_at) BETWEEN '".$time[0]."' AND '".$time[1]."'";

			$sql .= $frequency_query;
			
			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}
		}else if($frequency_shift == 'Once in A Day'){


			$sql = "SELECT * FROM water_meter_audits where water_m_id = ".$water_id."";

			if($current_time >= '00:00' && $current_time <= Shift_3_end){
				$current_date = date ('Y-m-d',strtotime('-1 day', strtotime(CURRENT_DATETIME)));
			}

			$sql .=" AND date(audit_date_time) = '".$current_date."'";
			
			$sql = $this->db->query($sql);

			if($sql->num_rows() > 0){
				$data = 'done';
			}else{
				$data = 'pending';
			}

		}else{
			$data = 'done';
		}		

    	return $data;
	}

	//not used
	function CheckFrequencyEntryDaily($water_m_id)
	{
		$uid=$this->session->userdata('uid'); 

		$sql = $this->db->query("select * from water_meter_audits where water_m_id = '".$water_m_id."' AND date(audit_date_time) = '".date("Y-m-d",strtotime(CURRENT_DATETIME))."'");

		//echo $this->db->last_query();

		if($sql->num_rows() > 0)
		{
			return "done";
		}
		else
		{
			return "pending";
		}
	}
	//not used
	function CheckFrequencyEntryMonthy($water_m_id,$startdate)
	{
		$uid=$this->session->userdata('uid'); 
		$enddate = date('Y-m-d', strtotime('+1 month', strtotime($startdate)));

		$sql = $this->db->query("select * from water_meter_audits where water_m_id = '".$water_m_id."' AND date(audit_date_time) BETWEEN '".$startdate."' AND '".$enddate."'");

		//echo $this->db->last_query();

		if($sql->num_rows() > 0)
		{
			return "done";
		}
		else
		{
			return "pending";
		}
	}

	

	function getLastSubmittedValueAudit($table,$fieldname,$id)
	{
		$this->db->where($fieldname, $id);
		$this->db->order_by("Id","DESC");
        $res = $this->db->get($table)->row();
        return $res;
	}

	function getPlantAdminEmail($plant_id){
		$query = $this->db->query("SELECT ifnull(GROUP_CONCAT(emailid),'') as admin_email FROM `employees` where plant_id = ".$plant_id."  AND Id IN (select empid from users where (role = 2 OR role = 4))");
		if($query->num_rows() > 0){
			return $email = $query->row()->admin_email;
		}else{
			return false;
		}
	}

	public function getWaterConsumptionValue($current_id,$water_id)
	{
		$sql = $this->db->query("select current_value from water_meter_audits where Id = (select Id from water_meter_audits where Id < '".$current_id."' AND water_m_id = '".$water_id."' ORDER BY Id DESC LIMIT 0,1 )");

		if($sql->num_rows() > 0){
			$result_value = $sql->row();
			return $result_value->current_value;
		}else{
			return 'false';
		}
	}

	public function sendDailyLogBookCronMail($shift_type,$message_table=null)
	{
		//'megha.sharma@unilever.com','nishant.srivastav@designx.in','dinesh.patil@unilever.com'

		$to = array('anukritika.jha@unilever.com','nishant.srivastav@designx.in','dinesh.patil@unilever.com','deep.sheth@designx.in');
		//$to = array('deep.sheth@designx.in','sutharkiran743@gmail.com');

		$from= "donotreply@techfilessolutions.in";
		$subject = 'Digital ETP Daily log book report - '.$shift_type;

		$message = "<p>Hello Admin</p>";
		$message .= "<p>Here is daily log book report.</p>";

		//$message .="<p>Click below link to view audit report.</p><br>";
		
		//$message .="<a href='".site_url()."etp/daily-log-book'>".site_url()."etp/daily-log-book</a>";

		if($message_table !=null){
			$message .= $message_table;
		}

		$res = $this->Common_model->sendemail($from,$to,$message,$subject);

		if($res){
			return true;
		}else{
			return false;
		}
	}

	//end of class...		
}

?>