
/*var path = window.location.pathname;
var str = path.split("/");
var path =  str;
*/

function paramAuditBarChart()
{
    var location_id = $("#locationId option:selected").val();
    var parameter_id = $("#parameter_id option:selected").val();
    var frequencyshift_value = $("#frequencyshift_value option:selected").val();
    
    if(location_id !='' && parameter_id !='')
    {
        $.ajax({
            type: 'POST',
            url: site_url+"EtpController/reportAuditBarChart",
            data:{location_id:location_id,parameter_id:parameter_id,frequencyshift_value:frequencyshift_value},
            success: function (data1)
            {
                jsonData = $.parseJSON(data1);
                    
                console.log(jsonData);

                var labels = [];
                var visit = [];

                for (var i = 0; i < jsonData.length; i++) 
                {
                    labels[i] = jsonData[i].month;
                    visit[i] = jsonData[i].total;           
                }
                
                $('#barChartParamAudit').remove(); // this is my <canvas> element
                $('#graph-container').append('<canvas id="barChartParamAudit" width="400" height="400"><canvas>');
                var ctx = document.getElementById("barChartParamAudit").getContext("2d");

                var myChart = new Chart(ctx, {
                type: 'bar',
                scaleOverride : true,
                scaleSteps : 10,
                scaleStepWidth : 50,
                scaleStartValue : 0,
                labelLength: 15,
                multiTooltipTemplate: "<%= datasetLabel %> - <%= value %>",
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Current Value',
                        backgroundColor:
                            'rgba(255, 102, 0,1)',
                        borderColor:'rgba(255,99,132,1)',
                        data: visit,
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:true,
                                //stepSize: 3
                            },
                            scaleLabel: {
                                display: true,
                                labelString: 'Range'
                            },
                            gridLines: {//remove grid line on chart background
                                display:false
                            }
                        },],
                       xAxes: [{
                            ticks: {
                                autoSkip: false,
                                maxTicksLimit: 27,
                            },
                            barPercentage: 0.4,
                            gridLines: {//remove grid line on chart background
                                display:false
                            }

                        }]
                    },
                    "animation": {
                        "duration": 1,
                        "onComplete": function () {
                            var chartInstance = this.chart,
                            ctx = chartInstance.ctx;

                            var fontColor = "black";
                            
                            ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'top';
                            ctx.fillStyle = fontColor;

                            this.data.datasets.forEach(function (dataset, i) {
                                var meta = chartInstance.controller.getDatasetMeta(i);
                                meta.data.forEach(function (bar, index) {
                                    var data = dataset.data[index];                            
                                    ctx.fillText(data, bar._model.x, bar._model.y -0);
                                });
                            });
                        }
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    legend:{
                        display:false   // Suppress interactive legend
                    },
                }
            });

            }
        });
    }
}


function getParameterList()
{
    var location_id = $("#locationId option:selected").val();

    $.ajax({
        type: 'POST',
        url: site_url+"EtpController/getParameterFromLocation",
        data:{location_id:location_id},
        success: function (data)
        {
            $(".parameterList").html(data);

            paramAuditBarChart();
        }
    });   
}

$('#locationId').on('change', function (e) {
    getParameterList();
});

$('.parameterList').on('change','#parameter_id', function (e) {
   paramAuditBarChart();
});

$('#frequencyshift_value').on('change',function (e) {
   paramAuditBarChart();
});

/*   new chart */


$('#parameter_tank').on('change',function (e) {
   paramAuditFinalTankLocation();
});
$('#frequencyshift_value_tank').on('change',function (e) {
   paramAuditFinalTankLocation();
});

function paramAuditFinalTankLocation()
{
    var location_id = $("#location_tank option:selected").val();
    var parameter_id = $("#parameter_tank option:selected").val();
    var frequencyshift_value = $("#frequencyshift_value_tank option:selected").val();
    
    if(location_id !='' && parameter_id !='')
    {
        $.ajax({
            type: 'POST',
            url: site_url+"EtpController/reportAuditFinalTankBarChart",
            data:{location_id:location_id,parameter_id:parameter_id,frequencyshift_value:frequencyshift_value},
            success: function (data1)
            {
                jsonData = $.parseJSON(data1);
                    
                console.log(jsonData);

                var labels = [];
                var visit = [];

                for (var i = 0; i < jsonData.length; i++) 
                {
                    labels[i] = jsonData[i].month;
                    visit[i] = jsonData[i].total;           
                }
                
                $('#barChartParamAuditFinalTank').remove(); // this is my <canvas> element
                $('#graph-container-final_tank').append('<canvas id="barChartParamAuditFinalTank" width="400" height="400"><canvas>');
                var ctx = document.getElementById("barChartParamAuditFinalTank").getContext("2d");

                var myChart = new Chart(ctx, {
                type: 'bar',
                scaleOverride : true,
                scaleSteps : 10,
                scaleStepWidth : 50,
                scaleStartValue : 0,
                labelLength: 15,
                multiTooltipTemplate: "<%= datasetLabel %> - <%= value %>",
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Current Value',
                        backgroundColor:
                            'rgba(255, 102, 0,1)',
                        borderColor:'rgba(255,99,132,1)',
                        data: visit,
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:true,
                                //stepSize: 3
                            },
                            scaleLabel: {
                                display: true,
                                labelString: 'Range'
                            },
                            gridLines: {//remove grid line on chart background
                                display:false
                            }
                        },],
                       xAxes: [{
                            ticks: {
                                autoSkip: false,
                                maxTicksLimit: 27,
                            },
                            barPercentage: 0.4,
                            gridLines: {//remove grid line on chart background
                                display:false
                            }
                        }]
                    },
                    "animation": {
                        "duration": 1,
                        "onComplete": function () {
                            var chartInstance = this.chart,
                            ctx = chartInstance.ctx;

                            var fontColor = "black";
                            
                            ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'top';
                            ctx.fillStyle = fontColor;

                            this.data.datasets.forEach(function (dataset, i) {
                                var meta = chartInstance.controller.getDatasetMeta(i);
                                meta.data.forEach(function (bar, index) {
                                    var data = dataset.data[index];                            
                                    ctx.fillText(data, bar._model.x, bar._model.y -0);
                                });
                            });
                        }
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    legend:{
                        display:false   // Suppress interactive legend
                    },
                }
            });

            }
        });
    }
}



