
/* Energy */
function EnergyMeterAuditBarChart()
{
    var energy_m_id = $("#energy_meter_list option:selected").val();
    var frequencyshift_value = $("#frequencyshift_value_energymeter option:selected").val();
    
    if(energy_m_id)
    {
        $.ajax({
            type: 'POST',
            url: site_url+"EnergyMeterController/reportEnergyAuditBarChart",
            data:{energy_m_id:energy_m_id,frequencyshift_value:frequencyshift_value},
            success: function (data1)
            {
                jsonData = $.parseJSON(data1);
                    
                console.log(jsonData);

                var labels = [];
                var visit = [];

                for (var i = 0; i < jsonData.length; i++) 
                {
                    labels[i] = jsonData[i].month;
                    visit[i] = jsonData[i].total;           
                }
                
                $('#barChartEnergyAudit').remove(); // this is my <canvas> element
                $('#graph-container').append('<canvas id="barChartEnergyAudit" width="400" height="400"><canvas>');
                var ctx = document.getElementById("barChartEnergyAudit").getContext("2d");

                var myChart = new Chart(ctx, {
                type: 'bar',
                scaleOverride : true,
                scaleSteps : 10,
                scaleStepWidth : 50,
                scaleStartValue : 0,
                labelLength: 15,
                multiTooltipTemplate: "<%= datasetLabel %> - <%= value %>",
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Current Value',
                        backgroundColor:
                            'rgba(255, 102, 0,1)',
                        borderColor:'rgba(255,99,132,1)',
                        data: visit,
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:true,
                                //stepSize: 3
                            },
                            scaleLabel: {
                                display: true,
                                labelString: 'Range'
                            },
                            gridLines: {//remove grid line on chart background
                                display:false
                            }
                        },],
                       xAxes: [{
                            ticks: {
                                autoSkip: false,
                                maxTicksLimit: 27,
                            },
                            barPercentage: 0.4,
                            gridLines: {//remove grid line on chart background
                                display:false
                            }

                        }]
                    },
                    "animation": {
                        "duration": 1,
                        "onComplete": function () {
                            var chartInstance = this.chart,
                            ctx = chartInstance.ctx;

                            var fontColor = "black";
                            
                            ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'top';
                            ctx.fillStyle = fontColor;

                            this.data.datasets.forEach(function (dataset, i) {
                                var meta = chartInstance.controller.getDatasetMeta(i);
                                meta.data.forEach(function (bar, index) {
                                    var data = dataset.data[index];                            
                                    ctx.fillText(data, bar._model.x, bar._model.y -0);
                                });
                            });
                        }
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    legend:{
                        display:false   // Suppress interactive legend
                    },
                }
            });

            }
        });
    }
}

$('#energy_meter_list').on('change', function (e) {
   EnergyMeterAuditBarChart();
});

$('#frequencyshift_value_energymeter').on('change',function (e) {
   EnergyMeterAuditBarChart();
});

function EnergyConsumptionGraph()
{
    var energy_m_id = $("#energy_meter_list_consumption option:selected").val();
    var frequencyshift_value = $("#frequencyshift_value_energymeter_consumption option:selected").val();
    
    if(energy_m_id)
    {
        $.ajax({
            type: 'POST',
            url: site_url+"EnergyMeterController/reportEnergyConsumptionGraph",
            data:{energy_m_id:energy_m_id,frequencyshift_value:frequencyshift_value},
            success: function (data1)
            {
                jsonData = $.parseJSON(data1);
                    
                console.log(jsonData);

                var labels = [];
                var visit = [];

                for (var i = 0; i < jsonData.length; i++) 
                {
                    labels[i] = jsonData[i].month;
                    visit[i] = jsonData[i].total;           
                }
                
                $('#barChartEnergyConsumption').remove(); // this is my <canvas> element
                $('#graph-container-consumption').append('<canvas id="barChartEnergyConsumption" width="400" height="400"><canvas>');
                var ctx = document.getElementById("barChartEnergyConsumption").getContext("2d");

                var myChart = new Chart(ctx, {
                type: 'bar',
                scaleOverride : true,
                scaleSteps : 10,
                scaleStepWidth : 50,
                scaleStartValue : 0,
                labelLength: 15,
                multiTooltipTemplate: "<%= datasetLabel %> - <%= value %>",
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Current Value',
                        backgroundColor:
                            'rgba(255, 102, 0,1)',
                        borderColor:'rgba(255,99,132,1)',
                        data: visit,
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:true,
                                //stepSize: 3
                            },
                            scaleLabel: {
                                display: true,
                                labelString: 'Range'
                            },
                            gridLines: {//remove grid line on chart background
                                display:false
                            }
                        },],
                       xAxes: [{
                            ticks: {
                                autoSkip: false,
                                maxTicksLimit: 27,
                            },
                            barPercentage: 0.4,
                            gridLines: {//remove grid line on chart background
                                display:false
                            }

                        }]
                    },
                    "animation": {
                        "duration": 1,
                        "onComplete": function () {
                            var chartInstance = this.chart,
                            ctx = chartInstance.ctx;

                            var fontColor = "black";
                            
                            ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'top';
                            ctx.fillStyle = fontColor;

                            this.data.datasets.forEach(function (dataset, i) {
                                var meta = chartInstance.controller.getDatasetMeta(i);
                                meta.data.forEach(function (bar, index) {
                                    var data = dataset.data[index];                            
                                    ctx.fillText(data, bar._model.x, bar._model.y -0);
                                });
                            });
                        }
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    legend:{
                        display:false   // Suppress interactive legend
                    },
                }
            });

            }
        });
    }
}

$('#energy_meter_list_consumption').on('change', function (e) {
   EnergyConsumptionGraph();
});

$('#frequencyshift_value_energymeter_consumption').on('change',function (e) {
   EnergyConsumptionGraph();
});

/* water */

function WaterMeterAuditBarChart()
{
    var water_m_id = $("#water_meter_list option:selected").val();
    var frequencyshift_value = $("#frequencyshift_value_watermeter option:selected").val();
    
    if(water_m_id)
    {
        $.ajax({
            type: 'POST',
            url: site_url+"WaterMeterController/reportWaterAuditBarChart",
            data:{water_m_id:water_m_id,frequencyshift_value:frequencyshift_value},
            success: function (data1)
            {
                jsonData = $.parseJSON(data1);
                    
                console.log(jsonData);

                var labels = [];
                var visit = [];

                for (var i = 0; i < jsonData.length; i++) 
                {
                    labels[i] = jsonData[i].month;
                    visit[i] = jsonData[i].total;           
                }
                
                $('#barChartWaterAudit').remove(); // this is my <canvas> element
                $('#graph-container').append('<canvas id="barChartWaterAudit" width="400" height="400"><canvas>');
                var ctx = document.getElementById("barChartWaterAudit").getContext("2d");

                var myChart = new Chart(ctx, {
                type: 'bar',
                scaleOverride : true,
                scaleSteps : 10,
                scaleStepWidth : 50,
                scaleStartValue : 0,
                labelLength: 15,
                multiTooltipTemplate: "<%= datasetLabel %> - <%= value %>",
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Current Value',
                        backgroundColor:
                            'rgba(255, 102, 0,1)',
                        borderColor:'rgba(255,99,132,1)',
                        data: visit,
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:true,
                                //stepSize: 3
                            },
                            scaleLabel: {
                                display: true,
                                labelString: 'Range'
                            },
                            gridLines: {//remove grid line on chart background
                                display:false
                            }
                        },],
                       xAxes: [{
                            ticks: {
                                autoSkip: false,
                                maxTicksLimit: 27,
                            },
                            barPercentage: 0.4,
                            gridLines: {//remove grid line on chart background
                                display:false
                            }

                        }]
                    },
                    "animation": {
                        "duration": 1,
                        "onComplete": function () {
                            var chartInstance = this.chart,
                            ctx = chartInstance.ctx;

                            var fontColor = "black";
                            
                            ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'top';
                            ctx.fillStyle = fontColor;

                            this.data.datasets.forEach(function (dataset, i) {
                                var meta = chartInstance.controller.getDatasetMeta(i);
                                meta.data.forEach(function (bar, index) {
                                    var data = dataset.data[index];                            
                                    ctx.fillText(data, bar._model.x, bar._model.y -0);
                                });
                            });
                        }
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    legend:{
                        display:false   // Suppress interactive legend
                    },
                }
            });

            }
        });
    }
}

$('#water_meter_list').on('change',function (e) {
   WaterMeterAuditBarChart();
});

$('#frequencyshift_value_watermeter').on('change',function (e) {
   WaterMeterAuditBarChart();
});


function WaterConsumptionGraph()
{
    var water_m_id = $("#water_meter_list_consumption option:selected").val();
    var frequencyshift_value = $("#frequencyshift_value_watermeter_consumption option:selected").val();
    
    if(water_m_id)
    {
        $.ajax({
            type: 'POST',
            url: site_url+"WaterMeterController/reportWaterConsumptionGraph",
            data:{water_m_id:water_m_id,frequencyshift_value:frequencyshift_value},
            success: function (data1)
            {
                jsonData = $.parseJSON(data1);
                    
                console.log(jsonData);

                var labels = [];
                var visit = [];

                for (var i = 0; i < jsonData.length; i++) 
                {
                    labels[i] = jsonData[i].month;
                    visit[i] = jsonData[i].total;           
                }
                
                $('#barChartWaterConsumption').remove(); // this is my <canvas> element
                $('#graph-container-consumption').append('<canvas id="barChartWaterConsumption" width="400" height="400"><canvas>');
                var ctx = document.getElementById("barChartWaterConsumption").getContext("2d");

                var myChart = new Chart(ctx, {
                type: 'bar',
                scaleOverride : true,
                scaleSteps : 10,
                scaleStepWidth : 50,
                scaleStartValue : 0,
                labelLength: 15,
                multiTooltipTemplate: "<%= datasetLabel %> - <%= value %>",
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Current Value',
                        backgroundColor:
                            'rgba(255, 102, 0,1)',
                        borderColor:'rgba(255,99,132,1)',
                        data: visit,
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:true,
                                //stepSize: 3
                            },
                            scaleLabel: {
                                display: true,
                                labelString: 'Range'
                            },
                            gridLines: {//remove grid line on chart background
                                display:false
                            }
                        },],
                       xAxes: [{
                            ticks: {
                                autoSkip: false,
                                maxTicksLimit: 27,
                            },
                            barPercentage: 0.4,
                            gridLines: {//remove grid line on chart background
                                display:false
                            }

                        }]
                    },
                    "animation": {
                        "duration": 1,
                        "onComplete": function () {
                            var chartInstance = this.chart,
                            ctx = chartInstance.ctx;

                            var fontColor = "black";
                            
                            ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'top';
                            ctx.fillStyle = fontColor;

                            this.data.datasets.forEach(function (dataset, i) {
                                var meta = chartInstance.controller.getDatasetMeta(i);
                                meta.data.forEach(function (bar, index) {
                                    var data = dataset.data[index];                            
                                    ctx.fillText(data, bar._model.x, bar._model.y -0);
                                });
                            });
                        }
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    legend:{
                        display:false   // Suppress interactive legend
                    },
                }
            });

            }
        });
    }
}

$('#water_meter_list_consumption').on('change', function (e) {
   WaterConsumptionGraph();
});

$('#frequencyshift_value_watermeter_consumption').on('change',function (e) {
   WaterConsumptionGraph();
});